#!/usr/bin/env bash

echo "ScheduleTime=$ScheduleTime"
LOG_TIME=$(date +%Y%m%d -d "-2 days $ScheduleTime")

date_path=${LOG_TIME:0:4}/${LOG_TIME:4:2}/${LOG_TIME:6:2}

source ../prd_env.sh

M_DAILY_INPUT_PATH="${ETL_ADN_SDK_REQUEST_DAILY}/${date_path}"
ADN_TOTAL_INPUT_PATH="${ADN_TOTAL_PATH}/${date_path}"
OUTPUT_PATH="${REQUEST_TMP_PATH}/etl_adn_sdk_request_daily/${date_path}"

hadoop fs -rmr ${OUTPUT_PATH}

REDUCE_NUM=$(calculate_reduce_num "${M_DAILY_INPUT_PATH}")

hadoop jar ../${JAR} mobvista.prd.datasource.country.interest.mapreduce.MergeMInterestDailyMR \
    -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
    ${M_DAILY_INPUT_PATH} ${ADN_TOTAL_INPUT_PATH} ${OUTPUT_PATH} ${REDUCE_NUM}

if [ $? -ne 0 ];then
  exit 255
fi