#!/usr/bin/env bash

# # # # # # # # # # # # # # # # # # # # # #
# @file    :get_m_country.sh
# @author  :liushuai
# @revision:2017-05-18 17:45
# @desc    ：分来源国家对dsp、m系统设备去重
# # # # # # # # # # # # # # # # # # # # # #

LOG_TIME=$(date +%Y%m%d -d "-6 day $ScheduleTime")
year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

source ../prd_env.sh

INPUT_PATH="${REQUEST_TMP_PATH}/dsp_join_m_3_day/${year}/${month}/${day}/"
OUTPUT_PATH="${REQUEST_TMP_PATH}/dsp_m_merge_3_day/${year}/${month}/${day}/"

hadoop fs -rmr ${OUTPUT_PATH}

hadoop jar ../${JAR} mobvista.prd.datasource.source.mapreduce.MergeCountryMJoinDspMR \
    -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
    ${INPUT_PATH} ${OUTPUT_PATH}

if [ $? -ne 0 ];then
  exit 255
fi