package mobvista.dmp.datasource.adn_sdk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import mobvista.dmp.common.Constants;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

import java.io.IOException;
import java.io.Serializable;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 刘凯 2018-01-18 16:20 adn_sdk 工具类
 */
public class AdnSdkTools extends UDF implements Serializable {
    final static String OLD_STR = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    final static String NEW_STR = "vSoajc7dRzpWifGyNxZnV5k+DHLYhJ46lt0U3QrgEuq8sw/XMeBAT2Fb9P1OIKmC";

    /**
     * 解密cal
     *
     * @param cal
     * @return
     */
    public static String evaluate(String cal) {
        //	System.out.println("AdnSdkTools.evaluate.cal:" + cal);
        String ret = "";
        try {
            cal = cal.replace(" ", "+");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < cal.length(); ++i) {
                char c = cal.charAt(i);
                if (NEW_STR.indexOf(c) == -1) {
                    //	System.out.println("wwpp==" + c);
                    sb.append(c);
                    continue;
                }
                char n = OLD_STR.charAt(NEW_STR.indexOf(c));
                sb.append(n);
            }
            cal = sb.toString();
            byte[] b;
            b = Base64.getDecoder().decode(cal);
            ret = new String(b, "UTF-8");
            //		System.out.println("AdnSdkTools.evaluate.ret:" + ret);
        } catch (Exception e) {

        }
        return ret;
    }

    /**
     * @param log
     * @return
     */
    public static JSONObject getEtlJSON(String log) {
        String ENCODING = "UTF-8";
        String platform = "";
        String device_id = "";
        String device_type = "";
        String gaid = "";
        String idfa = "";
        String model = "";
        String brand = "";
        String country = "";
        String sdk_version = "";
        String data = "";
        // String dvi = "";
        String imei = "";
        String android_id = "";
        try {
            JSONObject json = null;
            try {
/*
				 String log_decode = URLDecoder.decode(log, ENCODING);
				json = JSON.parseObject(log_decode);
*/
                //	json = JSON.parseObject(log);
                json = Constants.String2JSONObject(log);
                //	String log_decode = URLDecoder.decode(log, ENCODING);
                // System.out.println("AdnSdkTools.getEtlJSON.log_decode:" + log_decode);

            } catch (Exception e) {
                System.out.println("====log parsed error:" + log);
                //	e.printStackTrace();
                // json = JSON.parseObject(log);
            }
            JSONObject field_json = (JSONObject) json.get("@fields");
            String request_body = (String) field_json.get("request_body");
            if (request_body != null && !request_body.isEmpty()) {
				/*if(request_body.contains("platform=1&package_name=com.mintegral.sdk.demo&os_version=4.4.2&brand=Honor&model=CHM-UL00&gaid=d6b6833a-d7c5-4679-aab9-5d0bb0cdd0d2")){
					System.out.println("the contents is => " + log);
				}*/
                String buf[] = URLDecoder.decode(request_body, "utf-8").split("&");

                // String buf[] = request_body.split("&");
                JSONArray cal_array = null;
                for (int i = 0; i < buf.length; i++) {
                    String field_data = buf[i];
                    if (field_data.contains("platform")) {
                        field_data = field_data.substring(
                                field_data.indexOf("=") + 1,
                                field_data.length());
                        if (field_data.equals("1")) {
                            platform = "android";
                            device_type = "gaid";
                        } else if (field_data.equals("2")) {
                            platform = "ios";
                            device_type = "idfa";
                        }
                    } else if (field_data.contains("gaid")) {
                        gaid = field_data.substring(
                                field_data.indexOf("=") + 1,
                                field_data.length());
                    } else if (field_data.contains("idfa")) {
                        idfa = field_data.substring(
                                field_data.indexOf("=") + 1,
                                field_data.length());
                    } else if (field_data.contains("data")) {
                        data = URLDecoder.decode(field_data.substring(
                                field_data.indexOf("=") + 1).replaceAll("%(?![0-9a-fA-F]{2})", "%25"), ENCODING);
                    } else if (field_data.contains("model")) {
                        model = field_data.substring(
                                field_data.indexOf("=") + 1,
                                field_data.length());
                    } else if (field_data.contains("brand")) {
                        brand = field_data.substring(
                                field_data.indexOf("=") + 1,
                                field_data.length());
                    } else if (field_data.contains("country_code")) {
                        country = field_data.substring(
                                field_data.indexOf("=") + 1);
                    } else if (field_data.contains("sdk_version")) {
                        sdk_version = field_data.substring(
                                field_data.indexOf("=") + 1);
                    } else if (field_data.contains("imei")) {
                        imei = field_data.substring(
                                field_data.indexOf("=") + 1,
                                field_data.length());
                    } else if (field_data.contains("dvi")) {
                        try {

                            String dvi_info = field_data.substring(
                                    field_data.indexOf("=") + 1,
                                    field_data.length());
                            // json对象
                            String dviStr = CommonBase64Util.newBase64Decode(dvi_info);

                            JSONObject dviInfo = new JSONObject();
                            if (StringUtils.isNotBlank(dviStr)) {
                                //  dviInfo = JSON.parseObject(dviStr);
                                dviInfo = Constants.String2JSONObject(dviStr);
                            }

                            imei = (String) dviInfo.get("imei");
                            android_id = (String) dviInfo.get("android_id");


                        } catch (Exception e) {
                            e.printStackTrace();
                        }

                    }
                }
                if (platform.equals("android")) {
                    device_id = gaid;
                } else if (platform.equals("ios")) {
                    device_id = idfa;
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
        JSONObject result = new JSONObject();
        if ((data.contains("key=2000041") && data.contains("iex=1")) || data.contains("key=2000079")) {
            result.put("device_id", device_id);
            result.put("device_type", device_type);
            result.put("platform", platform);
            result.put("data", data);
            result.put("model", model);
            result.put("brand", brand);
            result.put("country", country);
            result.put("sdk_version", sdk_version);
            result.put("imei", imei);
            result.put("android_id", android_id);
        }
        // System.out.println("AdnSdkTools.getEtlJSON.result:" + result);
        return result;
    }

    /**
     * @param log
     * @return
     */
    public static JSONObject getEtlJsonV2(String log) {
        String ENCODING = "UTF-8";
        String platform = "";
        String device_id = "";
        String device_type = "";
        String gaid = "";
        String idfa = "";
        String model = "";
        String brand = "";
        String country = "";
        String sdk_version = "";
        String data = "";
        String imei = "";
        String android_id = "";
        try {
            JSONObject json;
            try {
                json = Constants.String2JSONObject(log);
            } catch (Exception e) {
                json = new JSONObject();
            }
            JSONObject field_json = json.getJSONObject("@fields");
            String request_body = field_json.getString("request_body");
            if (StringUtils.isNotBlank(request_body)) {
                String[] buf = URLDecoder.decode(request_body, "utf-8").split("&");
                for (int i = 0; i < buf.length; i++) {
                    String field_data = buf[i];
                    String[] kv = field_data.split("=", -1);
                    if (kv.length == 2) {
                        switch (kv[0].toLowerCase()) {
                            case "platform":
                                if ("1".equals(kv[1])) {
                                    platform = "android";
                                    device_type = "gaid";
                                } else if ("2".equals(kv[1])) {
                                    platform = "ios";
                                    device_type = "idfa";
                                }
                                break;
                            case "gaid":
                                gaid = kv[1];
                                break;
                            case "idfa":
                                idfa = kv[1];
                                break;
                            case "data":
                                data = URLDecoder.decode(kv[1], ENCODING);
                                //  data = URLDecoder.decode(URLDecoder.decode(kv[1], ENCODING), ENCODING);
                                break;
                            case "model":
                                model = kv[1];
                                break;
                            case "brand":
                                brand = kv[1];
                                break;
                            case "country_code":
                                country = kv[1];
                                break;
                            case "sdk_version":
                                sdk_version = kv[1];
                                break;
                            case "imei":
                                imei = kv[1];
                                break;
                            case "dvi":
                                try {
                                    String dvi_info = kv[1];
                                    // json对象
                                    String dviStr = CommonBase64Util.newBase64Decode(dvi_info);
                                    JSONObject dviInfo = new JSONObject();
                                    if (StringUtils.isNotBlank(dviStr)) {
                                        dviInfo = Constants.String2JSONObject(dviStr);
                                    }
                                    imei = (String) dviInfo.get("imei");
                                    android_id = (String) dviInfo.get("android_id");
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                                break;
                            default:
                                break;
                        }
                    }
                }
                if ("android".equals(platform)) {
                    device_id = gaid;
                } else if ("ios".equals(platform)) {
                    device_id = idfa;
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
        JSONObject result = new JSONObject();
        if ((data.contains("key=2000041") && data.contains("iex=1")) || data.contains("key=2000079") || data.contains("key=2000047")) {
            String rid_n = "";
            String reason = "";
            String hb = "";
            if (data.contains("key=2000047")) {
                String[] split = data.split("&");
                for (String row : split) {
                    String[] split1 = row.split("=",2);
                    if (split1.length == 2 && split1[0].equals("rid_n")){
                        rid_n = split1[1];
                    }
                    if (split1.length == 2 && split1[0].equals("reason")) {
                        reason = split1[1];
                    }
                    if (split1.length == 2 && split1[0].equals("hb")) {
                        hb = split1[1];
                    }
                }
                if((reason.equalsIgnoreCase("APP ALREADY INSTALLED") || reason.equalsIgnoreCase("No video campaign")) && rid_n.length()!=0 ){
                    result.put("rid_n", rid_n);
                }else{
                    result.put("rid_n", "");
                }
            }else {
                result.put("rid_n", "");
            }
            result.put("device_id", device_id);
            result.put("device_type", device_type);
            result.put("platform", platform);
            result.put("data", data);
            result.put("model", model);
            result.put("brand", brand);
            result.put("country", country);
            result.put("sdk_version", sdk_version);
            result.put("imei", imei);
            result.put("android_id", android_id);
            result.put("hb", hb);
        }
        return result;
    }

    public static JSONArray getSdkInstall(JSONArray array, String cal) {
        String a = cal.replaceAll("[{]", "##&");
        a = a.replaceAll("[}]", "##&");
        String json_data[] = a.split("##&");
        for (int i = 0; i < json_data.length; i++) {
            if (json_data[i].length() < 10) {
                continue;
            }
            String child[] = json_data[i].split(",");
            String packageName = "";
            long ts = 0l;
            String campaignid = "";
            String label = "";
            String iex = "";
            for (int j = 0; j < child.length; j++) {
                if (child[j].length() < 10) {
                    continue;
                }
                if (child[j].contains("\"packageName\"")) {
                    packageName = child[j].substring(child[j].indexOf(":") + 2,
                            child[j].length() - 1);
                } else if (child[j].contains("\"ts\"")) {
                    try {
                        ts = Long.valueOf(child[j].substring(
                                child[j].indexOf(":") + 2,
                                child[j].length() - 1));
                    } catch (Exception e) {

                    }
                } else if (child[j].contains("\"campaignid\"")) {
                    campaignid = child[j].substring(child[j].indexOf(":") + 2,
                            child[j].length() - 1);
                } else if (child[j].contains("\"label\"")) {
                    label = child[j].substring(child[j].indexOf(":") + 2,
                            child[j].length() - 1);
                } else if (child[j].contains("\"iex\"")) {
                    iex = child[j].substring(child[j].indexOf(":") + 2,
                            child[j].length() - 1);
                }

            }
            if (!packageName.isEmpty() && ts > 0) {
                JSONObject json = new JSONObject();
                json.put("package_name", packageName);
                SimpleDateFormat time_format = new SimpleDateFormat(
                        "yyyy-MM-dd");
                Date date = new Date();
                date.setTime(ts);
                String ins_day = time_format.format(date);
                json.put("date", ins_day);
                json.put("label", label);
                json.put("campaignid", campaignid);
                array.add(json);
            }

        }
        return array;
    }

    public static Map<String, String> getCampaignidPackagenameMap(String url) {
        Map<String, String> map = new HashMap<String, String>();
        try {
            JSONObject jsonObject = doGetJson(url);
            JSONObject data = (JSONObject) jsonObject.get("data");
            JSONObject priority_android_pkg = (JSONObject) data.get("priority_android_pkg");
            JSONObject offer_list = (JSONObject) priority_android_pkg.get("OFFER_LIST");
            Set<String> strings = offer_list.keySet();
            for (String str : strings) {
                System.out.println(str);
                JSONArray jsonArray = offer_list.getJSONArray(str);
                for (int i = 0; i < jsonArray.size(); i++) {
                    JSONObject jsonObject1 = jsonArray.getJSONObject(i);
                    map.put(jsonObject1.get("campaignid").toString(), jsonObject1.get("packageName").toString());
                }
            }

            JSONObject android_pkg = (JSONObject) data.get("android_pkg");
            JSONObject android_pkg_offer_list = (JSONObject) android_pkg.get("OFFER_LIST");
            Set<String> android_pkg_offer_list_strings = android_pkg_offer_list.keySet();
            for (String str : android_pkg_offer_list_strings) {
                JSONArray jsonArray = android_pkg_offer_list.getJSONArray(str);
                for (int i = 0; i < jsonArray.size(); i++) {
                    JSONObject jsonObject1 = jsonArray.getJSONObject(i);
                    map.put(jsonObject1.get("campaignid").toString(), jsonObject1.get("packageName").toString());
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return map;
    }

    public static JSONObject doGetJson(String url) throws IOException {
        JSONObject jsonObject = null;
        DefaultHttpClient client = new DefaultHttpClient();
        HttpGet httpGet = new HttpGet(url);
        HttpResponse response = client.execute(httpGet);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            String result = EntityUtils.toString(entity, "UTF-8");
            jsonObject = JSON.parseObject(result);
        }
        return jsonObject;
    }

/*	public static void main(String [] args) throws Exception{
		String decoders = "4BztYrxBYFQ3%2BFQ3RUE0iANTfrNeHrNAiURBfaDbfoRsRr2tYg5rDkfTJ%2BzQh0R1R3edxZRsRrfMJnR0G0zthr2QDkzuR0M0J7cghBR1RgzQY75thFVwLF5PhBRsRg5AH%2BR0G0zqHkP8LkPAR0M0hrc3LkI0G0z2Yrw%2FYbJ%2FR0M0DrKXJ7eXDkxQh0R1Rg5%2FLFPXJF90WozED%2Bz3JFcBHZR1Rr2ER0M0L7KAJoR1R3fixo2onjNTW5Hfi0TBiBRsRrfXH75%2FDk2QRUE0V35iR0M0LkPUhr5wHkPTDkM0G0ReGavBiAj9iaz0H7jbR0M0hF5BLkcsRUE0njJffAvMiFVTfkxQinh0Woz3L%2BfMY7cPRUE0n327iUHDR0M0DrKthrN0G0zwhFT9Gnib%2BAiBR0M0JdQMHZR1Rg5AH%2BR0WozAJ%2BSMYbzTRUE0D%2BzwHkc0LZ2FfFj0WozBHkeQD%2BfQRUE0fB9eWUj0WozAH7wuYgN0GUR2Woz0D%2BxTH%2BzPhbxtJd5ARUEMWoz0D%2BfQYbi0GUjsRrQAiUxRRUE0iUN0WozAHkPAYbR0GUNeWozuYkV0G0z8H%2BQ0hrKtHaSdYFKgY7VlJrKuDFVlJdQMLkPgR7wQ4kzBYFc3iVedRjwQ4kzXD%2Bz3RoRsRgSEYFPQJdQMHZR1WnRsRgxXJ7cshrcwRUE0fjJoR0M0J7KTDkewHk2Xhg30G0RAWUVbRjJoRgT%3D" ;

		String log_decode = URLDecoder.decode(decoders, "utf-8");

		System.out.println("========11111=============" + new String(b64Util_url.decode(decoders)));
		System.out.println("========000000000000=============");

		System.out.println("==========22222222===========" + CommonBase64Util.newBase64Decode(log_decode));





	*//*	String test="{ \"@timestamp\": \"05/Nov/2019:00:12:00 +0800\", \"@fields\": { \"remote_addr\": \"100.121.90.216\", \"remote_user\": \"-\", \"body_bytes_sent\": \"12\", \"status\": \"200\", \"http_host\": \"analytics.rayjump.com\", \"request\": \"POST / HTTP/1.1\", \"request_method\": \"POST\", \"request_body\": \"platform=1&package_name=com.qihoo.security&os_version=9&brand=OPPO&model=RMX1811&gaid=30ee9128-aee3-4d96-a29b-f2c634bf9947&mnc=864&mcc=405&network_type=13&network_str=13&language=en&timezone=&ua=Mozilla%252F5.0%2B%2528Linux%253B%2BAndroid%2B9%253B%2BRMX1811%2BBuild%252FPKQ1.190319.001%2529%2BAppleWebKit%252F535.19%2B%2528KHTML%252C%2Blike%2BGecko%2529%2BChrome%252F18.0.1025.133%2BMobile%2BSafari%252F535.19&gp_version=17.2.13-all%2B%255B0%255D%2B%255BPR%255D%2B276332444&sdk_version=MAL_9.7.01&app_version_name=5.3.7.4396&orientation=1&gpsv=12451000&screen_size=720x1520&dvi=4bT%3D&app_id=18988&unit_id=1910&data=key%253D2000022%2526network_type%253D13%2526network_str%253D13%2526result%253D1%2526duration%253D46105%2526video_size%253D4837371%2526video_length%253D30%2526reason%253Dnull%2526cid%253D321289176%2526video_url%253Dhttps%25253A%25252F%25252Fcdn-adn-https-baidu.rayjump.com%25252Fcdn-adn%25252Fvh%25252F19%25252F10%25252F28%25252F15%25252F27%25252F90e524ca17f6fa850cfcb126c88e8a6c.mp4%2526rid_n%253D5dc04d6ad000ed0221e5705x%2526unit_id%253D15163%2526offer_url%253Dhttps%25253A%25252F%25252Fsg01.rayjump.com%25252Fclick%25253Fk%25253D5dc04d6ad000ed0221e5705x%252526z%25253DVklERU98TU5vcm1hbEFscGhhTW9kZWxSYW5rZXJISDs1NDswOzA7NDA7MDswOzFfbW9vY19iYXNlLTk5OTlfMDszfDVkYzA0ZDZhZDAwMGVkMDIyMWU1NjFjeHwxfG9wcG98cm14MTgxMXx8MS40fDQwNTg2NA%2525253D%2525253D%252526q%25253Da_i09M6dfgiaj%2525252FhrcPLg5whoPUYF2IfkxUiax3frc3iavMHkNMiUReHnVbia596a53DAvTHaHtHavMi753iaRBikV2fUcU4dM2fal96aj9Gnl96aj2inDA6a3MibMAiUjBGa3efAHIi%2525252BMe67cbhbfg%2525252BFc3hF5BJr5B6aJIZVPIWncIincIi%2525252BMeGa39GdMbiAlb6aV%2525252FiB9bWUNAGnHIYbSQYrcML%2525252BMB6dMw6acIidMeGa39GdMM6aSIidMBfA3TibeIfdeIideUYFT%2525252FhkQEYFI%2525252FhF5UJ%2525252BzuJdQIigMBfAVAfni9ialA6aSI6a5IideIidMM6dMM6cs0iZRsRUj0WoR2R0M0fZzJ6aVTidMM6ajMiafI6aSIigeORrfuhBR1foM0H%2525252BtU%2525252BbS8HBR1RUv06%2525252BMMWUve6dwK%252526r%25253DeyJnaWQiOiJhMzIyNGUxYWQ0YzNkYzkzNzk3NGM3ZWJiMDk2Njc4MCIsInRwaWQiOjAsImNyYXQiOjcsImFkdl9jcmlkIjoxNzk3NzA2MywiaWNjIjoxLCJnbGlzdCI6IjQwNSwyNzUzNTM2NjU2LDAsfDQwNiwyNzUzNTM2NjU4LDAsfDIwMSwyNzUzNTM4MDgzLDE3OTc3MDYzLDE5MjB4MTA4MHw0MDEsMjc1MzUzNjY0NiwwLHw0MDIsMjc1MzUzNjY1MCwwLHw0MDMsMjc1MzUzNjY1MiwwLHw0MDQsMjc1MzUzNjY1NCwwLCIsInBpIjoxLCJwbyI6MSwiZGNvIjowLCJjcl9uYW1lIjoiYmlub21vX3RpbWVfYW5kcm9pZF8xOTIweDEwODBfaW5fMS5tcDQifQ%2525253D%2525253D%252526al%25253D321289176%2525252C2019110500%2525252C1%2525252C6.61635e-06%2525252C0.00661635%2525252C2%2525252C5%2525252Cxx%2525252C1%2525252C47.74.225.214%2525252C0%2525252C0%2525252C0%2525252C3%2525252Cnone%2525252Cnone%2525252Cnone%2525252Cnone%2525252Cmoct_1101%2525252Ccrt%2525250410%252525040%2525250410%252525040%252525040%2525252Cxx%2525252Cnative%2525252C0%2525252Cxx%2525252C0%2525252C13%2525252C40%2525252C0.000000%252525040.000000%25252504%2525252C0%2525252C0.00572772%252525040.00572772%2525252C0%2525252Cxxx%2525252Csg%2525252Cxxx%2525252C0%252525042753538083%252525040%2525252CMsysRetr%2525253B0%2525252C0%252526csp%25253DinJIinh1iAReiUlPinhFGUcIiUhPfafIiUlBidMefAE1ibMe6acI4BzULoR1invMiajsRrxAh7Q3RUEFWozULkN0G0RAiUjBGa3efAD0WoztH7T0GrP2Y7MsRrz3RUE0R0M0hdzuDF56Lk90GUv%2525252FfnhBfAheGaV9faRAGnN9iBM0hdzuDF56Yb5TRUEMWUVbiUhbinl2GaNBiA3TGaisRrQA%2525252BFt0RUEMWozMhrQUH5KBD%2525252Bh0GUv%2525252FfnhBfAheGaV9faRAGnN9iBM0J7c9RUEeWozrDkwQRUEeWoztJkfTLkK%2525252FRUEeWURsRrcr%2525252Bbxt4oR1io92fARbfAj9fnlTiUiPfalAWozMhrQUH5KBH0R1io92fARbfAj9fnlTiUiPfalAWozMhrQUH5KBHgN0GUv%2525252FfnhBfAheGaV9faRAGnN9iBM0hdzuDF56hrHTDZR1io9FGahAiUDBiAveialbiAlsRrHMhrQUHZR1io92fARbfAj9fnlTiUiPfalAWoztJdQMHZR1i%2525252BT%2525253D%252526c%25253D42%2525257C1%2525257C9%2525257CMAL_9.7.01%2525257CRMX1811%2525257C720x1520%2525257C1%2525257Cen%2525257C13%2525257C405864%2525257C%2525257C%2525257C%2525257C30ee9128-aee3-4d96-a29b-f2c634bf9947%2525257C%2525257COPPO%2525257C%252526notice%25253D1%250A&m_sdk=msdk&channel=\", \"http_referrer\": \"-\", \"http_x_forwarded_for\": \"49.35.18.22\", \"http_user_agent\": \"Apache-HttpClient/UNAVAILABLE (java 1.4)\",\"request_time\": \"0.011\"}}";
		JSONObject jsonObject = AdnSdkTools.getEtlJSON(test);
		System.out.println(jsonObject);*//*
	}*/
}
