package mobvista.dmp.main;

import com.google.common.io.Files;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.*;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 验证产品excel中标签是否正确
 */
public class ValidateTags {

    public static void main(String[] args) throws Exception {
        Set<String> set = new HashSet<String>();
        List<String> cateList = Files.readLines(new File("/home/dulei/tmp/dim_category_new"), Charset.defaultCharset());
        for (String line : cateList) {
            set.add(line.split("\t", -1)[3]);
        }

        InputStream in = new FileInputStream("/home/dulei/Desktop/人工标注结果0713-0716.xlsx");
        Workbook workbook = WorkbookFactory.create(in, "");
        Sheet sheet = workbook.getSheetAt(0);

        for (int i = 1; i < sheet.getLastRowNum() + 1; i++) {
            Row row = sheet.getRow(i);
            if (row != null) {
                String packageName = getCellValue(row.getCell(0)).trim();
                String platform = getCellValue(row.getCell(1)).trim();
                String tagType = getCellValue(row.getCell(2)).trim();
                String tag1 = getCellValue(row.getCell(3)).trim();
                String tag2 = getCellValue(row.getCell(4)).trim();
                String tag3 = getCellValue(row.getCell(5)).trim();
                String tag4 = getCellValue(row.getCell(6)).trim();
                String tag5 = getCellValue(row.getCell(7)).trim();

                if (!"ios".equalsIgnoreCase(platform) && !"android".equalsIgnoreCase(platform)) {
                    System.out.println("platform error ");
                    System.out.println("line: " + i + " platform: " + platform);
                }


                if (!set.contains(tag1) && StringUtils.isNotEmpty(tag1)) {
                    System.out.println("tag1 error ");
                    System.out.println("line: " + i + " package: " + packageName + " tag: " + tag1);
                }
                if (!set.contains(tag2) && StringUtils.isNotEmpty(tag2)) {
                    System.out.println("tag2 error ");
                    System.out.println("line: " + i + " package: " + packageName + " tag: " + tag2);
                }
                if (!set.contains(tag3) && StringUtils.isNotEmpty(tag3)) {
                    System.out.println("tag3 error ");
                    System.out.println("line: " + i + " package: " + packageName + " tag: " + tag3);
                }
                if (!set.contains(tag4) && StringUtils.isNotEmpty(tag4)) {
                    System.out.println("tag4 error ");
                    System.out.println("line: " + i + " package: " + packageName + " tag: " + tag4);
                }
                if (!set.contains(tag5) && StringUtils.isNotEmpty(tag5)) {
                    System.out.println("tag5 error ");
                    System.out.println("line: " + i + " package: " + packageName + " tag: " + tag5);
                }

            }
        }

    }

    public static String getCellValue(Cell cell){
        if (cell != null) {
            if (cell.getCellType() == 0) {
                return String.valueOf((long)cell.getNumericCellValue());
            } else {
                return cell.getStringCellValue();
            }
        } else {
            return "";
        }
    }
}
