package mobvista.prd.datasource.dao;

import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import java.util.Map;


public interface DBCommonDAO {
	
	/**
	 * 通用查询方法，返回Map集合
	 * @param sql
	 * @param params
	 * @return
	 * @throws Exception
	 */
	public List<Map<String, Object>> findMapList(String sql, Object[] params) throws Exception;

    /**
     *
     * @param conn
     * @param sql
     * @param params
     * @param closeConn
     * @return
     * @throws Exception
     */
    public List<Map<String, Object>> findMapList(Connection conn, String sql, Object[] params, boolean closeConn) throws Exception;
	
	/**
	 * 通用查询数据方法，返回clazz类型集合
	 * @param sql
	 * @param params
	 * @param clazz
	 * @return
	 * @throws Exception
	 */
	public <T> List<T> findListByClass(String sql, Object[] params, Class<T> clazz) throws Exception;
	
	/**
	 * 通用更新方法
	 * @param sql 更新语句
	 * @param params 参数
	 * @return
	 * @throws Exception
	 */
	public int update(String sql, Object[] params) throws Exception ;

	/**
	 *
	 * @param conn
	 * @param sql
	 * @param params
	 * @param closeConn
	 * @return
	 * @throws Exception
	 */
	public int update(Connection conn, String sql, Object[] params, boolean closeConn) throws Exception;

	/**
	 * 通用新增方法
	 * @param obj
	 * @return
	 * @throws Exception
	 */
	public Integer persist(Serializable obj) throws Exception;

	/**
	 * 通过sql插入数据方法
	 * @param conn
	 * @param sql
	 * @param params
	 * @return
	 * @throws Exception
	 */
	public int insert(Connection conn, String sql, Object[] params, boolean closeConn) throws Exception;
	
	/**
	 * 通过sql插入数据方法
	 * @param sql
	 * @param params
	 * @return
	 * @throws Exception
	 */
	public int insert(String sql, Object[] params) throws Exception; 
	
}
