package mobvista.prd.datasource.main;

import mobvista.prd.datasource.dao.ExportExcelDAO;
import mobvista.prd.datasource.dao.impl.ExportExcelDAOImpl;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.*;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 生成DMP标签数据报表
 * Created by fl on 2017/5/15.
 */
public class GenerateTagReport {
    private static final Logger log = Logger.getLogger(GenerateTagReport.class);
    private List<String> ageColumns = new ArrayList<>();
    private List<String> ageHeadColumns = new ArrayList<String>();
    private List<String> genderColumns = new ArrayList<String>();
    private List<String> genderHeadColumns = new ArrayList<String>();
    private List<String> interestColumns = new ArrayList<String>();
    private List<String> interestHeadColumns = new ArrayList<String>();

    private List<String> ageCntColumns = new ArrayList<>();
    private List<String> ageCntHeadColumns = new ArrayList<String>();
    private List<String> genderCntColumns = new ArrayList<String>();
    private List<String> genderCntHeadColumns = new ArrayList<String>();
    private List<String> interestCntColumns = new ArrayList<String>();
    private List<String> interestCntHeadColumns = new ArrayList<String>();


    public void init () {
        ageHeadColumns.add("date");
        ageHeadColumns.add("ageRange");
        ageHeadColumns.add("sampleSize");
        ageHeadColumns.add("algorithmCalculate");

        ageColumns.add("day_key");
        ageColumns.add("dimension_desc2");
        ageColumns.add("sample");
        ageColumns.add("recommend");

        ageCntHeadColumns.add("date");
        ageCntHeadColumns.add("country");
        ageCntHeadColumns.add("ageRange");
        ageCntHeadColumns.add("sampleSize");
        ageCntHeadColumns.add("algorithmCalculate");

        ageCntColumns.add("day_key");
        ageCntColumns.add("dimension_desc2");
        ageCntColumns.add("dimension_desc3");
        ageCntColumns.add("sample");
        ageCntColumns.add("recommend");

        genderHeadColumns.add("date");
        genderHeadColumns.add("gender");
        genderHeadColumns.add("sampleSize");
        genderHeadColumns.add("algorithmCalculate");

        genderColumns.add("day_key");
        genderColumns.add("dimension_desc2");
        genderColumns.add("sample");
        genderColumns.add("recommend");

        genderCntHeadColumns.add("date");
        genderCntHeadColumns.add("country");
        genderCntHeadColumns.add("gender");
        genderCntHeadColumns.add("sampleSize");
        genderCntHeadColumns.add("algorithmCalculate");

        genderCntColumns.add("day_key");
        genderCntColumns.add("dimension_desc2");
        genderCntColumns.add("dimension_desc3");
        genderCntColumns.add("sample");
        genderCntColumns.add("recommend");

        interestHeadColumns.add("date");
        interestHeadColumns.add("firstTag");
        interestHeadColumns.add("secondTag");
        interestHeadColumns.add("sampleSize");

        interestColumns.add("day_key");
        interestColumns.add("dimension_desc2");
        interestColumns.add("dimension_desc3");
        interestColumns.add("sample");

        interestCntHeadColumns.add("date");
        interestCntHeadColumns.add("country");
        interestCntHeadColumns.add("firstTag");
        interestCntHeadColumns.add("secondTag");
        interestCntHeadColumns.add("sampleSize");

        interestCntColumns.add("day_key");
        interestCntColumns.add("dimension_desc2");
        interestCntColumns.add("dimension_desc3");
        interestCntColumns.add("dimension_desc4");
        interestCntColumns.add("sample");

    }

    public int run (String[] args) throws Exception {
        if (args.length < 2) {
            log.info("Usage: GenerateTagReport <date> <output>");
            return 1;
        }

        init();

        OutputStream out = null;
        try {
            String date = args[0];
            String output = args[1];
            Path reportFile = new Path(output);
            FileSystem fs = FileSystem.get(URI.create(output), new Configuration());
            out = fs.create(reportFile);
//            out = new FileOutputStream(output);

            ExportExcelDAO dao = new ExportExcelDAOImpl();
            List<Map<String, Object>> ageList = dao.findDataByTag(date, "年龄", "整体");
            List<Map<String, Object>> genderList = dao.findDataByTag(date, "性别","整体");
            List<Map<String, Object>> interestList = dao.findInterestTagData(date, "整体");
            List<Map<String, Object>> ageCntList = dao.findDataByTag(date, "年龄", "分国家");
            List<Map<String, Object>> genderCntList = dao.findDataByTag(date, "性别","分国家");
            List<Map<String, Object>> interestCntList = dao.findInterestTagData(date, "分国家");

            HSSFWorkbook workbook = new HSSFWorkbook();
            buildExcel(workbook, "年龄", ageHeadColumns, ageColumns, ageList);
            buildExcel(workbook, "性别", genderHeadColumns, genderColumns, genderList);
            buildExcel(workbook, "兴趣", interestHeadColumns, interestColumns, interestList);
            buildExcel(workbook, "年龄-分国家", ageCntHeadColumns, ageCntColumns, ageCntList);
            buildExcel(workbook, "性别-分国家", genderCntHeadColumns, genderCntColumns, genderCntList);
            buildExcel(workbook, "兴趣-分国家", interestCntHeadColumns, interestCntColumns, interestCntList);
            workbook.write(out);
        } catch (Exception e) {
            throw e;
        } finally {
            if (out != null) {
                out.close();
            }
        }

        return 0;
    }


    public void buildExcel(HSSFWorkbook workbook, String sheetName, List<String> headColumns, List<String> columns,
                           List<Map<String, Object>> dataColumns) {

        HSSFSheet sheet = workbook.createSheet(sheetName);
        sheet.setColumnWidth(0, 5000);
        sheet.setColumnWidth(1, 5000);
        sheet.setColumnWidth(2, 5000);
        sheet.setColumnWidth(3, 5000);

        HSSFFont headFont = workbook.createFont();
        headFont.setBold(true);
        headFont.setFontHeightInPoints((short) 12);

        HSSFCellStyle headStyle = workbook.createCellStyle();
        headStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);
        headStyle.setFont(headFont);

        HSSFRow head = sheet.createRow(0);
        for (int i = 0; i < headColumns.size(); i++) {
            HSSFCell cell = head.createCell(i);
            cell.setCellStyle(headStyle);
            cell.setCellValue(headColumns.get(i));
        }

        Map<String, Object> map = null;
        for (int i=0; i< dataColumns.size(); i++) {
            map = dataColumns.get(i);
            HSSFRow row = sheet.createRow(i + 1);
            for (int j=0; j<columns.size(); j++) {
                HSSFCell cell = row.createCell(j);
                cell.setCellValue(String.valueOf(map.get(columns.get(j))));
            }
        }
    }


    public static void main(String[] args) {
        try {
            new GenerateTagReport().run(args);
        } catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}
