package mobvista.prd.datasource.table;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.poi.hssf.usermodel.*;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2017/3/27 0027.
 * desc:创建dsp指定app的国家性别年龄
 */
public class CreateDspAppTable {

    public static void main(String[] args) throws IOException {
        Map<String, Map<String, List<String>>> countryMap = readCountryApp("./dspAppCountNum.txt");
        FileOutputStream fos = new FileOutputStream("./DSP指定app的国家性别年龄.xls");
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet s;
        int sheet = 0;
        for (Map.Entry<String, Map<String, List<String>>> country : countryMap.entrySet()) {
            s = wb.createSheet();
            wb.setSheetName(sheet, country.getKey());//以国家名创建sheet
            List<String> head = Lists.newArrayList();//表头
            head.add("APP name");
            head.add("platform(iOS/Android)");
            head.add("address(GP/App Store)");
            head.add("category");
            head.add("DMP DAU");
            head.add("Male");
            head.add("Female");
            head.add("Gender unknown");
            head.add("Age 0-18");
            head.add("Age 19-25");
            head.add("Age 26-45");
            head.add("Age 46-60");
            head.add("Age 61 and above");
            head.add("Age unknown");
            int columnHead = 0;
            HSSFRow rowOne = s.createRow(0);
            for (String column : head) {
                HSSFCell cell = rowOne.createCell(columnHead, 0);
                HSSFRichTextString hts = new HSSFRichTextString(column);
                cell.setCellValue(hts);
                columnHead++;
            }
            int rowLine = 1;
            for (Map.Entry<String, List<String>> packageCount : country.getValue().entrySet()) {
                HSSFRow row = s.createRow(rowLine);  //行
                int columnNum = 0;
                for (String column : packageCount.getValue()) {
                    HSSFCell cell = row.createCell(columnNum, 0);
                    HSSFRichTextString hts = new HSSFRichTextString(column);
                    cell.setCellValue(hts);
                    columnNum++;
                }

                rowLine++;
            }
            sheet++;
        }
        wb.write(fos);
        fos.flush();
        fos.close();
    }

    public static Map readCountryApp(String file) throws IOException {
        Map<String, Map<String, List<String>>> countryMap = Maps.newHashMap();

        FileReader fr = new FileReader(file);
        BufferedReader br = new BufferedReader(fr);
        String s = br.readLine();
        while (s != null) {
            Map<String, List<String>> partMap = Maps.newHashMap();
            String[] fields = s.split("\t", -1);
            String country = fields[14];

            List<String> list = Lists.newArrayList();

            list.add(fields[0]);
            list.add(fields[1]);
            list.add(fields[2]);
            list.add(fields[3]);
            list.add(fields[4]);
            list.add(fields[5]);
            list.add(fields[6]);
            list.add(fields[7]);
            list.add(fields[8]);
            list.add(fields[9]);
            list.add(fields[10]);
            list.add(fields[11]);
            list.add(fields[12]);
            list.add(fields[13]);
            partMap = countryMap.get(country);
            if (partMap == null) {
                partMap = Maps.newHashMap();
            }
            partMap.put(fields[0], list);
            countryMap.put(country, partMap);//包信息
            s = br.readLine();//再读下一行
        }
        return countryMap;
    }
}
