package mobvista.prd.datasource.table;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import mobvista.prd.datasource.dao.ExportExcelDAO;
import mobvista.prd.datasource.dao.impl.ExportExcelDAOImpl;
import org.apache.poi.hssf.usermodel.*;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Created by liushuai on 2017/3/13 0013.
 * desc:M系统指定app的国家性别年龄
 */
public class CreateMAppTable {

    public static Map<String, Map<String, String>> maxAppMap = Maps.newHashMap();

    public static void main(String[] args) {
        HSSFWorkbook wb = null;
        FileOutputStream fos = null;
        try {
            maxAppMap = readMaxApp("./maxAppName.txt");
            Map<String, Map<String, List<String>>> countryMap = readCountryApp("./appCountNum.txt", args[0]);
            fos = new FileOutputStream("./M系统指定app的国家性别年龄.xls");
            wb = new HSSFWorkbook();
            HSSFSheet s;
            int sheet = 0;
            for (Map.Entry<String, Map<String, List<String>>> country : countryMap.entrySet()) {
                s = wb.createSheet();
                wb.setSheetName(sheet, country.getKey());//以国家名创建sheet
                List<String> head = Lists.newArrayList();//表头
                head.add("APP name");
                head.add("APPID");
                head.add("platform(iOS/Android)");
                head.add("package name");
                head.add("address(GP/App Store)");
                head.add("category");
                head.add("DMP DAU");
                head.add("Male");
                head.add("Female");
                head.add("Gender unknown");
                head.add("Age 0-18");
                head.add("Age 19-25");
                head.add("Age 26-45");
                head.add("Age 46-60");
                head.add("Age 61 and above");
                head.add("Age unknown");
                head.add("mysql DAU");
                int columnHead = 0;
                HSSFRow rowOne = s.createRow(0);
                for (String column : head) {
                    HSSFCell cell = rowOne.createCell(columnHead, 0);
                    HSSFRichTextString hts = new HSSFRichTextString(column);
                    cell.setCellValue(hts);
                    columnHead++;
                }
                int rowLine = 1;
                for (Map.Entry<String, List<String>> packageCount : country.getValue().entrySet()) {
                    HSSFRow row = s.createRow(rowLine);  //行
                    int columnNum = 0;
                    for (String column : packageCount.getValue()) {
                        HSSFCell cell = row.createCell(columnNum, 0);
                        HSSFRichTextString hts = new HSSFRichTextString(column);
                        cell.setCellValue(hts);
                        columnNum++;
                    }

                    rowLine++;
                }
                sheet++;
            }

        } catch (Exception e) {
            e.printStackTrace();
            System.exit(255);
        } finally {
            try {
                if (wb != null) {
                    wb.write(fos);
                }

                if (fos != null) {
                    fos.flush();
                    fos.close();
                }

            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static Map readCountryApp(String file, String date) throws Exception {
        Map<String, Map<String, List<String>>> countryMap = Maps.newHashMap();

        FileReader fr = new FileReader(file);
        BufferedReader br = new BufferedReader(fr);
        String s = br.readLine();
        while (s != null) {
            Map<String, List<String>> partMap = Maps.newHashMap();
            String[] fields = s.split("\t", -1);
            String country = fields[15];
            String packageName = "";

            Map<String, String> cou = maxAppMap.get(country);
            if (cou == null) {
                packageName = "";
                fields[3] = "";
                fields[4] = "";
            } else {
                String line = cou.get(fields[0]);
                if (line == null) {
                    packageName = "";
                    fields[3] = "";
                    fields[4] = "";
                } else {
                    packageName = line.split("\t", -1)[2];
                    fields[2] = line.split("\t", -1)[3];
                    fields[3] = line.split("\t", -1)[0];
                    fields[4] = line.split("\t", -1)[1];
                }
            }

            ExportExcelDAO dao = new ExportExcelDAOImpl();
            String dau = dao.getAppDau(country, fields[1], date, fields[2]);//country,app_id,date,platform
            List<String> list = Lists.newArrayList();
            list.add(fields[0]);//APP name
            list.add(fields[1]);//APPID
            list.add(fields[2]);//platform(iOS/Android)
            list.add(packageName);
            list.add(fields[3]);//address(GP/App Store)
            list.add(fields[4]);//category
            list.add(fields[5]);//DMP DAU
            list.add(fields[6]);//男
            list.add(fields[7]);//女
            list.add(fields[8]);//未知性别
            list.add(fields[9]);//0-17
            list.add(fields[10]);//18-24
            list.add(fields[11]);//25-44
            list.add(fields[12]);//45-59
            list.add(fields[13]);//60+
            list.add(fields[14]);//未知年龄
            list.add(dau);//mysql dau
            partMap = countryMap.get(country);
            if (partMap == null) {
                partMap = Maps.newHashMap();
            }
            List<String> mList = partMap.get(fields[0]); //app_name
            if (mList == null) {
                partMap.put(fields[0], list);
            } else {
                int mCount = Integer.parseInt(list.get(6));//DAU
                int oldMCount = Integer.parseInt(mList.get(6)); //DAU
                if (mCount > oldMCount) {
                    partMap.put(fields[0], list);
                }
            }
            countryMap.put(country, partMap);//包信息
            s = br.readLine();//再读下一行
        }
        return countryMap;
    }

    public static Map readMaxApp(String file) throws IOException {
        Map<String, Map<String, String>> maxMap = Maps.newHashMap();

        FileReader fr = new FileReader(file);
        BufferedReader br = new BufferedReader(fr);
        String s = br.readLine();
        while (s != null) {
            Map<String, String> partMap = Maps.newHashMap();
            String[] fields = s.split("\t", -1);
            partMap = maxMap.get(fields[7]);
            if (partMap == null) {
                partMap = Maps.newHashMap();
                partMap.put(fields[0],
                        fields[4] + "\t" + fields[5] + "\t" + fields[2] + "\t" + fields[3] + "\t" + fields[6]);
                maxMap.put(fields[7], partMap);
            } else {
                String maxCount = partMap.get(fields[0]);
                if (maxCount == null) {
                    partMap.put(fields[0],
                            fields[4] + "\t" + fields[5] + "\t" + fields[2] + "\t" + fields[3] + "\t" + fields[6]);
                    maxMap.put(fields[7], partMap);
                } else {
                    String[] arr = maxCount.split("\t", -1);
                    if (Integer.parseInt(arr[4]) < Integer.parseInt(fields[6])) {
                        partMap.put(fields[0],
                                fields[4] + "\t" + fields[5] + "\t" + fields[2] + "\t" + fields[3] + "\t" + fields[6]);
                        maxMap.put(fields[7], partMap);
                    }
                }
            }
            s = br.readLine();//再读下一行
        }
        return maxMap;
    }
}
