package mobvista.prd.datasource.util;

import com.google.gson.*;

public class GsonUtil {

    public static JsonElement toJsonTree(Object obj) {
        if (obj != null) {
            Gson gson = new Gson();
            return gson.toJsonTree(obj);
        }
        return null;
    }

    public static String toJson(Object obj) {
        if (null == obj) {
            return null;
        }
        Gson gson = new Gson();
        return gson.toJson(obj);
    }

    public static <T> T fromJson(JsonElement json, Class<T> clazz) {
        if (json == null || clazz == null) {
            return null;
        }
        Gson gson = new Gson();
        return gson.fromJson(json, clazz);
    }

    /**
     * 将字符串转换为JsonArray
     *
     * @param str
     * @return
     */
    public static JsonArray String2JsonArray(String str) {
        if (null != str && !"".equals(str)) {
            JsonParser parser = new JsonParser();
            try {
                JsonElement element = parser.parse(str);
                if (element.isJsonArray()) {
                    return element.getAsJsonArray();
                } else {
                    return new JsonArray();
                }
            } catch (Exception e) {
                return new JsonArray();
            }
        }
        return new JsonArray();
    }

    /**
     * 将字符串转换为JsonObject
     *
     * @param str
     * @return
     */
    public static JsonObject String2JsonObject(String str) {
        if (null != str && !"".equals(str)) {
            JsonParser parser = new JsonParser();
            try {
                JsonElement element = parser.parse(str);
                return element.getAsJsonObject();
            } catch (Exception e) {
                return new JsonObject();
            }
        }
        return new JsonObject();
    }
}
