package mobvista.prd.datasource.util;

import com.google.gson.JsonObject;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.log4j.Logger;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

public class HttpUtil {
	
	public static String postRequest(String reqUrl, Map<String, Object> paramMap, Logger log) throws Exception {
		PostMethod post = new PostMethod(reqUrl);
		HttpClient client = new HttpClient();
      
		try {
			if (paramMap!= null) {
				Iterator<Entry<String, Object>> itr = paramMap.entrySet().iterator();
				Entry<String, Object> entry;
				while (itr.hasNext()) {
					entry = itr.next();
					post.addParameter(entry.getKey(), String.valueOf(entry.getValue()));
				}
			}
			post.getParams().setParameter(HttpMethodParams.HTTP_CONTENT_CHARSET,"utf-8");
			client.getHttpConnectionManager().getParams().setConnectionTimeout(50000);
			int status = client.executeMethod(post);
			if (status == HttpStatus.SC_OK) {
				return post.getResponseBodyAsString();
			} else {
				log.error("=============http client error===============");
				log.error("param=" + post.getParameters().toString());
				log.error(post.getResponseBodyAsString());
				log.error("=============================================");
				throw new RuntimeException("HTTP请求失败");
			}
		} finally {
			post.releaseConnection();
		}
	}
	
	public static String getRequest(String reqUrl, Map<String, Object> paramMap, Logger log) throws Exception {
		return getRequest(reqUrl, paramMap, null, log);
	}

	public static String getRequest(String reqUrl, Map<String, Object> paramMap, Map<String, String> headerMap, Logger log) throws Exception {
		GetMethod get = new GetMethod(reqUrl);
		HttpClient client = new HttpClient();
		StringBuilder builder = new StringBuilder();

		try {
			if (paramMap!= null) {
				Iterator<Entry<String, Object>> itr = paramMap.entrySet().iterator();
				Entry<String, Object> entry;
				while (itr.hasNext()) {
					entry = itr.next();
					if (builder.length() == 0) {
						builder.append("?").append(entry.getKey()).append("=").append(entry.getValue());
					} else {
						builder.append("&").append(entry.getKey()).append("=").append(entry.getValue());
					}
				}
			}

			if (headerMap != null) {
				Entry<String, String> entry = null;
				Iterator<Entry<String, String>> itr =  headerMap.entrySet().iterator();
                List<Header> headers = new ArrayList<Header>();
				while (itr.hasNext()) {
					entry = itr.next();
					headers.add(new Header(entry.getKey(), entry.getValue()));
				}
                client.getHostConfiguration().getParams().setParameter("http.default-headers", headers);
			}

            get = new GetMethod(URLDecoder.decode(reqUrl + builder.toString(), "UTF-8"));
			get.getParams().setParameter(HttpMethodParams.HTTP_CONTENT_CHARSET, "UTF-8");
			client.getParams().setParameter(HttpMethodParams.HTTP_CONTENT_CHARSET, "UTF-8");
			client.getHttpConnectionManager().getParams().setConnectionTimeout(50000);
			int status = client.executeMethod(get);
			if (status == HttpStatus.SC_OK) {
				return get.getResponseBodyAsString();
			} else {
				log.error("=============http client error===============");
				log.error("param=" + paramMap);
				log.error(get.getResponseBodyAsString());
				log.error("=============================================");
				throw new RuntimeException("HTTP请求失败 \n " + get.getResponseBodyAsString());
			}
		} finally {
		    if (get != null) {
                get.releaseConnection();
            }
		}
	}

	/**
	 *
	 * @param url
	 * @param json
	 * @param log
	 * @return
	 * @throws Exception
	 */
	public static String postRequestJson (String url, JsonObject json, Logger log) throws Exception {
		return postRequestJson(url, json, null, log);
	}

	/**
     *
     * @param url
     * @param json
	 * @param headerMap
     * @param log
     * @return
     * @throws Exception
     */
	public static String postRequestJson (String url, JsonObject json, Map<String, String> headerMap, Logger log) throws Exception {
        PostMethod post = new PostMethod(url);
        HttpClient client = new HttpClient();

        try {

            if (headerMap != null) {
                Entry<String, String> entry = null;
                Iterator<Entry<String, String>> itr =  headerMap.entrySet().iterator();
                List<Header> headers = new ArrayList<Header>();
                while (itr.hasNext()) {
                    entry = itr.next();
                    headers.add(new Header(entry.getKey(), entry.getValue()));
                }
                client.getHostConfiguration().getParams().setParameter("http.default-headers", headers);
            }

            RequestEntity requestEntity = new StringRequestEntity(json.toString(), "application/json", "UTF-8");
            post.setRequestEntity(requestEntity);
            post.getParams().setParameter(HttpMethodParams.HTTP_CONTENT_CHARSET,"utf-8");
            client.getHttpConnectionManager().getParams().setConnectionTimeout(50000);
            int status = client.executeMethod(post);
            if (status == HttpStatus.SC_OK) {
                return post.getResponseBodyAsString();
            } else {
                log.error("=============http client error===============");
                log.error("json=" + post.getParameters().toString());
                log.error(post.getResponseBodyAsString());
                log.error("=============================================");
                throw new RuntimeException("HTTP请求失败 " + post.getResponseBodyAsString());
            }
        } finally {
            post.releaseConnection();
        }
    }
	
	public static void main(String[] args) throws Exception {
		String reqUrl = "http://testnews.erp.sina.com.cn/index.php/paysettlement/imei_interface/silent_result";
//		String reqUrl = "http://testnews.erp.sina.com.cn/index.php/paysettlement/imei_interface/silent_result?is_id=1&is_total=100&is_status=成功&is_updatetime=2016-07-01 11:09:00&is_result_path=''";
		
	}
}
