package mobvista.dmp.datasource.adn_adx

/**
  * author andy.liu on 2019/9/24
  */

import java.net.URI

import mobvista.dmp.common.CommonSparkJob
import org.apache.commons.cli.Options
import org.apache.hadoop.fs.{FileSystem, Path}
import org.apache.spark.sql.{SaveMode, SparkSession}

class AdnAdxDeviceTag extends CommonSparkJob {


  override protected def buildOptions(): Options = {
    val options = new Options
    options.addOption("outputadxdevtag", true, "[must] outputadxdevtag")
    options.addOption("coalesce", true, "[must] coalesce")
    options.addOption("today", true, "[must] today")
    options.addOption("yesterday",true ,"[must] yesterday")
    options
  }

  override protected def run(args: Array[String]): Int = {
    val commandLine = commParser.parse(options, args)
    if (!checkMustOption(commandLine)) {
      printUsage(options)
      return -1
    } else printOptions(commandLine)

    val outputadxdevtag = commandLine.getOptionValue("outputadxdevtag")
    val yesterday = commandLine.getOptionValue("yesterday")
    val coalesce = commandLine.getOptionValue("coalesce")
    val today = commandLine.getOptionValue("today")

    val spark = SparkSession.builder()
      .appName("AdnAdxDeviceTag")
      .config("spark.rdd.compress", "true")
      .config("spark.io.compression.codec", "snappy")
      .config("spark.sql.orc.filterPushdown", "true")
      .config("spark.sql.warehouse.dir", "s3://mob-emr-test/spark-warehouse")
      .config("spark.serializer", "org.apache.spark.serializer.KryoSerializer")
      .enableHiveSupport()
      .getOrCreate()

    FileSystem.get(new URI(s"s3://mob-emr-test"), spark.sparkContext.hadoopConfiguration).delete(new Path(outputadxdevtag), true)

    try {

      // 数据量很少，直接写表操作

      val dim_adn_adx_package=
        s"""
           |select t2.device_id,
           |t2.device_type,
           |t2.platform,
           |t2.device_model,
           |t2.os_version,
           |t2.country,
           | coalesce(t4.gender, '10') gender,
           | t1.package_name,
           | t3.first_tag  tag,
           | t2.price_raw price,
           | t2.`date`
           |from (select request_id,substr(package,3)     package_name
           |from adn_report.adndata_midway_backend_v2 where  concat(yyyy,mm,dd) = '${today}' and  platform ='2' and backend_id = '17' ) t1
           |join (select * from dwh.ods_adn_adx_req_tmp where dt = '${today}' ) t2
           |on(t1.request_id = t2.request_id)
           |join (select package_name,platform,first_tag from dwh.dim_package_tags where first_tag in ('lightgame','moderategame','hardcoregame') ) t3
           |on(t1.package_name= t3.package_name and t3.platform = 'ios')
           |left join (select device_id,device_type,gender from dwh.dmp_device_gender where dt ='${yesterday}' ) t4
           |on(t2.device_id = t4.device_id and t2.device_type = t4.device_type)
           |group by t2.device_id,
           |t2.device_type,
           |t2.platform,
           |t2.device_model,
           |t2.os_version,
           |t2.country,
           | coalesce(t4.gender, '10'),
           | t1.package_name,
           | t3.first_tag,
           | t2.price_raw,
           | t2.`date`
      """.stripMargin

      spark.sql(dim_adn_adx_package)
        .coalesce(coalesce.toInt)
        .write.
        mode(SaveMode.Overwrite)
        .option("orc.compress", "zlib")
        .orc(outputadxdevtag)


    } finally {
      spark.stop()
    }
    0
  }
}

object AdnAdxDeviceTag {
  def main(args: Array[String]): Unit = {
    new AdnAdxDeviceTag().run(args)
  }
}
