package mobvista.dmp.datasource.adn_request_other

import mobvista.dmp.common.CommonInstallList
import mobvista.dmp.datasource.mpsdk.InstallInfo

class AdnRequestOtherInstall extends CommonInstallList with Serializable {
  /**
    * 解析天处理结果数据
    *
    * @param array
    * @param date
    * @return
    */
  override def processDailyData(array: Array[String], date: String): Array[(String, InstallInfo)] = {
    val result = new Array[Tuple2[String, InstallInfo]](1)
    val key = s"${array(0)}$DATA_SPLIT${array(1)}$DATA_SPLIT${array(2)}"
    val installInfo = new InstallInfo(array(3), date)
    result(0) = (key, installInfo).asInstanceOf[Tuple2[String, InstallInfo]]
    result
  }

}

object AdnRequestOtherInstall {
  def main(args: Array[String]): Unit = {
    new AdnRequestOtherInstall().run(args)
  }
}
