package mobvista.dmp.datasource.newtag

import org.apache.hadoop.io.Text
import org.apache.orc.TypeDescription
import org.apache.orc.mapred.OrcStruct

/**
  * @package: mobvista.dmp.datasource.newtag
  * @author: wangjf
  * @date: 2019/3/18
  * @time: 下午3:16
  * @email: jinfeng.wang@mobvista.com
  * @phone: 152-1062-7698
  */
class CustomIteratorDailyV2(iter: Iterator[DeviceTagDaily]) extends Iterator[(Text, OrcStruct)] {
  val schema = "struct<device_id:string,device_type:string,platform:string,package_name:string,interest_tag:string>"

  def hasNext: Boolean = {
    iter.hasNext
  }

  def next: (Text, OrcStruct) = {
    val deviceTagDaily = iter.next

    val deviceId = deviceTagDaily.device_id
    val deviceType = deviceTagDaily.device_type
    val platform = deviceTagDaily.platform
    val package_name = deviceTagDaily.package_name
    val interestTag = deviceTagDaily.interest_tag
    val path = deviceTagDaily.path

    val struct = OrcStruct.createValue(TypeDescription.fromString(schema)).asInstanceOf[OrcStruct]
    struct.setFieldValue(0, new Text(deviceId))
    struct.setFieldValue(1, new Text(deviceType))
    struct.setFieldValue(2, new Text(platform))
    struct.setFieldValue(3, new Text(package_name))
    struct.setFieldValue(4, new Text(interestTag))
    (new Text(path), struct)
  }
}