package mobvista.dmp.datasource.reyun

import mobvista.dmp.common.CommonInstallList
import mobvista.dmp.datasource.mpsdk.InstallInfo
import scala.collection.mutable.ArrayBuffer

/**
 * @author jiangfan
 * @date 2021/6/1 16:34
 */
class ReyunInstallList  extends CommonInstallList {
  override def processDailyData(array: Array[String], date: String): Array[(String, InstallInfo)] = {
    val buffer = new ArrayBuffer[(String, InstallInfo)]()
    val device_id = array(0)
    val device_type = array(1)
    val platform = array(2)
    val package_name = array(3)
    buffer += Tuple2(s"$device_id$FIELD_SPLIT$device_type$FIELD_SPLIT$platform", new InstallInfo(package_name, date))
    buffer.toArray
  }
}

object ReyunInstallList {
  def main(args: Array[String]): Unit = {
    new ReyunInstallList().run(args)
  }
}
