package mobvista.dmp.datasource.taobao

import java.net.URI

import mobvista.dmp.common.CommonSparkJob
import mobvista.dmp.format.TextMultipleOutputFormat
import org.apache.commons.cli.Options
import org.apache.commons.lang.StringUtils
import org.apache.hadoop.fs.{FileSystem, Path}
import org.apache.hadoop.io.Text
import org.apache.spark.sql.{Row, SparkSession}

import scala.collection.mutable.ArrayBuffer


class EtlOtherDataFromPostBackDaily extends CommonSparkJob with Serializable  {

  def buildRes( row: Row) : Array[Tuple2[Text, Text]] = {
    val buffer = new ArrayBuffer[Tuple2[Text, Text]]()
    val device_id = row.getAs[String]("device_id")
    val device_type = row.getAs[String]("device_type")
    val package_number = row.getAs[String]("package_number")
    val outputpath = package_number+"_"+device_type
    if (StringUtils.isNotBlank(outputpath)) {
      buffer += Tuple2(new Text(s"${outputpath}, "), new Text(device_id))
    }
    buffer.toArray
  }

  override protected def buildOptions(): Options = {
    val options = new Options
    options.addOption("dt_today", true, "[must] dt_today")
    options.addOption("dt_oneday_ago", true, "[must] dt_oneday_ago")
    options.addOption("output",true, "[must] output")
    options
  }

  override protected def run(args: Array[String]): Int = {
    val commandLine = commParser.parse(options, args)
    if (!checkMustOption(commandLine)) {
      printUsage(options)
      return -1
    } else printOptions(commandLine)

    val dt_today = commandLine.getOptionValue("dt_today")
    val dt_oneday_ago = commandLine.getOptionValue("dt_oneday_ago")
    val output = commandLine.getOptionValue("output")


    val spark = SparkSession.builder()
      .appName("EtlOtherDataFromPostBackDaily")
      .config("spark.rdd.compress", "true")
      .config("spark.io.compression.codec", "snappy")
      .config("spark.sql.orc.filterPushdown", "true")
      .config("spark.sql.warehouse.dir", "s3://mob-emr-test/spark-warehouse")
      .config("spark.serializer", "org.apache.spark.serializer.KryoSerializer")
      .enableHiveSupport()
      .getOrCreate()



    FileSystem.get(new URI(s"s3://mob-emr-test"), spark.sparkContext.hadoopConfiguration).delete(new Path(output), true)


    val sc = spark.sparkContext
    sc.hadoopConfiguration.set("mapreduce.fileoutputcommitter.marksuccessfuljobs", "false")
    try {

//      val sql5 =
//        s"""
//           |select distinct t1.device_id from
//           |(select device_id from dwh.dm_install_list_v2
//           |where dt='${dt_today}' and business='ali_activation' and device_type='imei'
//           |and package_name in ('com.taobao.foractivation.204543')) t1
//           |inner join
//           |(select device_id from dwh.dm_install_list_v2
//           |where dt='${dt_oneday_ago}' and business='dsp_req' and device_type='imei'
//           |and package_name in ('com.taobao.taobao_oppo')) t2
//           |on t1.device_id=t2.device_id
//        """.stripMargin
//
//      spark.sql(sql5).rdd.map(_.mkString).coalesce(50)
//        .saveAsTextFile(output05)
//
//      val sql6 =
//        s"""
//           |select distinct t1.device_id from
//           |(select device_id from dwh.dm_install_list_v2
//           |where dt='${dt_today}' and business='ali_activation' and device_type='imeimd5'
//           |and package_name in ('com.taobao.foractivation.204543')) t1
//           |inner join
//           |(select device_id from dwh.dm_install_list_v2
//           |where dt='${dt_oneday_ago}' and business='dsp_req' and device_type='imeimd5'
//           |and package_name in ('com.taobao.taobao_oppo')) t2
//           |on t1.device_id=t2.device_id
//        """.stripMargin
//
//      spark.sql(sql6).rdd.map(_.mkString).coalesce(50)
//        .saveAsTextFile(output06)

            val sql1 =
              s"""
                 |select  t1.device_id,t1.device_type,'204543' as package_number from
                 |(select device_id,device_type from dwh.dm_install_list_v2
                 |where dt='${dt_today}' and business='ali_activation' and device_type in ('imei','imeimd5')
                 |and package_name in ('com.taobao.foractivation.204543')) t1
                 |inner join
                 |(select device_id,device_type from dwh.dm_install_list_v2
                 |where dt='${dt_oneday_ago}' and business='dsp_req' and device_type in ('imei','imeimd5')
                 |and package_name in ('com.taobao.taobao_oppo')) t2
                 |on t1.device_id=t2.device_id
                 |group by t1.device_id,t1.device_type
                 |union
                 |select t1.device_id,t1.device_type,'227229' as package_number from
                 |(select device_id,device_type from dwh.dm_install_list_v2
                 |where dt='${dt_today}' and business='ali_activation' and device_type in ('imei','imeimd5')
                 |and package_name in ('com.taobao.foractivation.227229')) t1
                 |inner join
                 |(select device_id,device_type from dwh.dm_install_list_v2
                 |where dt='${dt_oneday_ago}' and business='dsp_req' and device_type in ('imei','imeimd5')
                 |and package_name in ('com.taobao.taobao_oppo')) t2
                 |on t1.device_id=t2.device_id
                 |group by t1.device_id,t1.device_type
                 |union
                 |select t1.device_id,t1.device_type,'188844' as package_number  from
                 |(select device_id,device_type from dwh.dm_install_list_v2
                 |where dt='${dt_today}' and business='ali_activation' and device_type in ('imei','imeimd5')
                 |and package_name in ('com.taobao.foractivation.188844')) t1
                 |inner join
                 |(select device_id,device_type from dwh.dm_install_list_v2
                 |where dt='${dt_oneday_ago}' and business='dsp_req' and device_type in ('imei','imeimd5')
                 |and package_name in ('com.taobao.taobao_oppo')) t2
                 |on t1.device_id=t2.device_id
                 |group by t1.device_id,t1.device_type
                 |union
                 |select  t2.device_id,t2.device_type,'iqyi_227229' as package_number from
                 |(select device_id,device_type from dwh.dm_install_list_v2
                 |where dt='${dt_today}' and business='ali_activation' and device_type='imeimd5'
                 |and package_name in ('com.taobao.foractivation.227229')) t1
                 |right join
                 |(select device_id,device_type from dwh.dm_install_list_v2
                 |where dt='${dt_oneday_ago}' and business='dsp_req' and device_type in ('oaidmd5','imeimd5')
                 |and package_name in ('com.iqiyi_android.subtract_with_227229')) t2
                 |on t1.device_id=t2.device_id
                 |where t1.device_id is null and t2.device_type='imeimd5'
                 |group by t2.device_id,t2.device_type
                 |union
                 |select  t2.device_id,t2.device_type,'iqyi_227229' as package_number from
                 |(select device_id,device_type from dwh.dm_install_list_v2
                 |where dt='${dt_today}' and business='ali_activation' and device_type='oaidmd5'
                 |and package_name in ('com.taobao.foractivation.227229_oaid')) t1
                 |right join
                 |(select device_id,device_type from dwh.dm_install_list_v2
                 |where dt='${dt_oneday_ago}' and business='dsp_req' and device_type in ('oaidmd5','imeimd5')
                 |and package_name in ('com.iqiyi_android.subtract_with_227229')) t2
                 |on t1.device_id=t2.device_id
                 |where t1.device_id is null and t2.device_type='oaidmd5'
                 |group by t2.device_id,t2.device_type
              """.stripMargin

            spark.sql(sql1).rdd.flatMap(buildRes(_)).coalesce(100)
              .saveAsNewAPIHadoopFile(s"${output}", classOf[Text], classOf[Text], classOf[TextMultipleOutputFormat], spark.sparkContext.hadoopConfiguration)

//      val sql7 =
//        s"""
//           |select distinct t1.device_id from
//           |(select device_id from dwh.dm_install_list_v2
//           |where dt='${dt_today}' and business='ali_activation' and device_type='imei'
//           |and package_name in ('com.taobao.foractivation.227229')) t1
//           |inner join
//           |(select device_id from dwh.dm_install_list_v2
//           |where dt='${dt_oneday_ago}' and business='dsp_req' and device_type='imei'
//           |and package_name in ('com.taobao.taobao_oppo')) t2
//           |on t1.device_id=t2.device_id
//        """.stripMargin
//
//      spark.sql(sql7).rdd.map(_.mkString).coalesce(50)
//        .saveAsTextFile(output07)
//
//      val sql8 =
//        s"""
//           |select distinct t1.device_id from
//           |(select device_id from dwh.dm_install_list_v2
//           |where dt='${dt_today}' and business='ali_activation' and device_type='imeimd5'
//           |and package_name in ('com.taobao.foractivation.227229')) t1
//           |inner join
//           |(select device_id from dwh.dm_install_list_v2
//           |where dt='${dt_oneday_ago}' and business='dsp_req' and device_type='imeimd5'
//           |and package_name in ('com.taobao.taobao_oppo')) t2
//           |on t1.device_id=t2.device_id
//        """.stripMargin
//
//      spark.sql(sql8).rdd.map(_.mkString).coalesce(50)
//        .saveAsTextFile(output08)

//      val sql9 =
//        s"""
//           |select distinct t1.device_id from
//           |(select device_id from dwh.dm_install_list_v2
//           |where dt='${dt_today}' and business='ali_activation' and device_type='imei'
//           |and package_name in ('com.taobao.foractivation.188844')) t1
//           |inner join
//           |(select device_id from dwh.dm_install_list_v2
//           |where dt='${dt_oneday_ago}' and business='dsp_req' and device_type='imei'
//           |and package_name in ('com.taobao.taobao_oppo')) t2
//           |on t1.device_id=t2.device_id
//        """.stripMargin
//
//      spark.sql(sql9).rdd.map(_.mkString).coalesce(50)
//        .saveAsTextFile(output09)
//
//      val sql10 =
//        s"""
//           |select distinct t1.device_id from
//           |(select device_id from dwh.dm_install_list_v2
//           |where dt='${dt_today}' and business='ali_activation' and device_type='imeimd5'
//           |and package_name in ('com.taobao.foractivation.188844')) t1
//           |inner join
//           |(select device_id from dwh.dm_install_list_v2
//           |where dt='${dt_oneday_ago}' and business='dsp_req' and device_type='imeimd5'
//           |and package_name in ('com.taobao.taobao_oppo')) t2
//           |on t1.device_id=t2.device_id
//        """.stripMargin
//
//      spark.sql(sql10).rdd.map(_.mkString).coalesce(50)
//        .saveAsTextFile(output10)


//      val sql11 =
//        s"""
//           |select distinct t2.device_id from
//           |(select device_id from dwh.dm_install_list_v2
//           |where dt='${dt_today}' and business='ali_activation' and device_type='imeimd5'
//           |and package_name in ('com.taobao.foractivation.227229')) t1
//           |right join
//           |(select device_id from dwh.dm_install_list_v2
//           |where dt='${dt_oneday_ago}' and business='dsp_req' and device_type='imeimd5' and platform='android'
//           |and package_name in ('com.iqiyi_android.subtract_with_227229')) t2
//           |on t1.device_id=t2.device_id
//           |where t1.device_id is null
//        """.stripMargin
//
//      spark.sql(sql11).rdd.map(_.mkString).coalesce(50)
//        .saveAsTextFile(output11)
//
//      val sql12 =
//        s"""
//           |select distinct t2.device_id from
//           |(select device_id from dwh.dm_install_list_v2
//           |where dt='${dt_today}' and business='ali_activation' and device_type='oaidmd5'
//           |and package_name in ('com.taobao.foractivation.227229_oaid')) t1
//           |right join
//           |(select device_id from dwh.dm_install_list_v2
//           |where dt='${dt_oneday_ago}' and business='dsp_req' and device_type='oaidmd5' and platform='android'
//           |and package_name in ('com.iqiyi_android.subtract_with_227229')) t2
//           |on t1.device_id=t2.device_id
//           |where t1.device_id is null
//        """.stripMargin

//      val sql12 =
//              s"""
//                 |select distinct t2.device_id_md5 from
//                 |(select device_id from dwh.dm_install_list_v2
//                 |where dt='${dt_today}' and business='ali_activation' and device_type='oaidmd5'
//                 |and package_name in ('com.taobao.foractivation.227229_oaid')) t1
//                 |right join
//                 |(select MD5(device_id) as device_id_md5 from dwh.dm_install_list_v2
//                 |where dt='${dt_oneday_ago}' and business='dsp_req' and device_type='oaid' and platform='android'
//                 |and package_name in ('com.iqiyi_android.subtract_with_227229')) t2
//                 |on t1.device_id=t2.device_id_md5
//                 |where t1.device_id is null
//              """.stripMargin

//      spark.sql(sql12).rdd.map(_.mkString).coalesce(50)
//        .saveAsTextFile(output12)

  } finally {
    spark.stop()
  }
  0
  }
}



object EtlOtherDataFromPostBackDaily {
  def main(args: Array[String]): Unit = {
    new EtlOtherDataFromPostBackDaily().run(args)
  }
}

