package mobvista.prd.main

import mobvista.prd.datasource.util.GsonUtil
import org.apache.commons.lang.StringUtils
import org.apache.spark.SparkContext
import org.apache.spark.sql.SparkSession

import scala.collection.JavaConversions._
import scala.collection.mutable.ArrayBuffer

/**
  * 计算某天分国家，分标签的活跃设备量和安装量（包名不去重）
  * Created by fl on 2017/7/20.
  */
class ActiveInstall extends Serializable {
  val dataSplit = "\t"

  def run (args : Array[String]): Int = {
    var sc : SparkContext = null
    try {

      val date = args(0)
      val appTagPath = args(1)
      val installPath = args(2)
      val outputPath = args(3)

      val spark = SparkSession.builder()
        .appName("ActiveInstall")
        .config("spark.serializer", "org.apache.spark.serializer.KryoSerializer")
        .getOrCreate()
      sc = spark.sparkContext
      import spark.implicits._

      val appTagData = sc.textFile(appTagPath)
      val appTagDF = appTagData.flatMap(record => {
        val list = new ArrayBuffer[String]()
        val splits = StringUtils.splitPreserveAllTokens(record, dataSplit, -1)
        val packageName = splits(0)
        val tags = splits(3)
        try {
          val jsonArray = GsonUtil.String2JsonArray(tags)
          for (element <- jsonArray) {
            val obj = element.getAsJsonObject
            val firstTag = obj.get("1").getAsString
            var secondTag = ""
            if (obj.get("2") != null) {
              secondTag = obj.get("2").getAsString
            }
//            list += AppTag(packageName, firstTag, secondTag)
            list += packageName + dataSplit + firstTag + dataSplit + secondTag
          }
        } catch {
          case e : Exception => {
            e.printStackTrace()
          }
        }
        list
      }).saveAsTextFile("s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/dmp_app_tag")



      val installData = sc.textFile(installPath)
      val installDF = installData.filter(_.contains(date)).flatMap(record => {
        val list = new ArrayBuffer[String]()
        val splits = StringUtils.splitPreserveAllTokens(record, dataSplit, -1)
        val device_id = splits(0)
        val device_type = splits(1)
        val installList = splits(3)
        val jsonArray = GsonUtil.String2JsonArray(installList)
        try {
          for ( element <- jsonArray) {
            val obj = element.getAsJsonObject
            if (obj.get("date").getAsString.equals(date)) {
              val packageName = obj.get("package_name").getAsString
//              list += InstallList(device_id, device_type, packageName)
              list += device_id + dataSplit + device_type + dataSplit + packageName
            }
          }
        } catch {
          case e : Exception => {
            e.printStackTrace()
          }
        }
        list
      }).saveAsTextFile("s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/dmp_install_list")


//      installDF.createOrReplaceTempView("dmp_install_list")
//      installDF.write.format("parquet").saveAsTable("dmp_install_list")

//      val dt = date.replaceAll("-", "")
//      val sql =
        s"""
           |
           |select t.country, t.firstTag, t.secondTag, count(1) as didCnt, sum(t.cnt) as installCnt
           |from (
           |select c.country, a.firstTag, a.secondTag, b.device_id, b.device_type, count(1) as cnt
           |from dmp_app_tag a
           |join dmp_install_list b on a.packageName = b.packageName
           |join (
           |  select *
           |  from dwh.ods_dmp_device_total t
           |  where t.dt=''
           |) c on b.device_id=c.device_id and b.device_type=c.device_type
           |group by c.country, a.firstTag, a.secondTag, b.device_id, b.device_type
           |) t
           |group by t.country, t.firstTag, t.secondTag
         """.stripMargin
//
//      spark.sql(sql).map(row => {
//        row.mkString("\t")
//      }).rdd.saveAsTextFile(outputPath)


    } finally {
      if (sc != null) {
        sc.stop()
      }
    }
    0
  }
}

object ActiveInstall {
  def main(args: Array[String]): Unit = {
    new ActiveInstall().run(args)
  }
}


case class AppTag (packageName : String, firstTag : String, secondTag : String)
case class InstallList (device_id : String, device_type : String, packageName : String)