package test;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import mobvista.dmp.util.DateUtil;
import mobvista.dmp.util.MRUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

import java.io.*;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * author: houying
 * date  : 16-10-13
 * desc  :
 */
public class Test {

    public static void main(String[] args) throws Exception {

       String prefix =longestSerialSubstring("s3://mob-ad/adn/tracking-v3/impression/2018/12/05/seoul/12","s3://mob-ad/adn/tracking-v3/impression/2018/12/05/virginia/12");
        System.out.println(prefix);

        List<String> list = Files.readLines(new File("/Users/fl/Downloads/test.html"), Charset.defaultCharset());
        StringBuffer buffer = new StringBuffer();
        for (String str: list) {
            buffer.append(str).append("\n");
        }

        ObjectMapper objectMapper = new ObjectMapper();

        Element element = Jsoup.parse(buffer.toString()).select("body div").first();
        String appName = element.select("h1[itemprop='name']").first().text();
        Elements cateElements = element.select("a[itemprop='genre']");
        List<Map<String, String>> categoryList = Lists.newArrayList();
        for (Element category: cateElements) {
            String code = category.attr("href").replace("https://play.google.com/store/apps/category/", "");
            String name = category.text();
            Map<String, String> map = Maps.newHashMap();
            map.put("code", code);
            map.put("name", name);
            categoryList.add(map);
        }

        Elements rateElements = element.select("meta[itemprop='ratingCount']");
        String userRatingCount = rateElements.size() == 0 ? "0": rateElements.first().attr("content"); //用户评分

        String download = "0";
        Elements otherInfoElements = element.select("c-wiz[jsrenderer='Wnurre'] div[class='hAyfc']");
        if (otherInfoElements.size() >= 3) {
            Elements downloadElements = otherInfoElements.get(2).select("span[class='htlgb']");
            if (downloadElements.size() > 0) {
                download = downloadElements.first().text();
            }
        }

        System.out.println("appName = " + appName);
        System.out.println("cateList = " + objectMapper.writeValueAsString(categoryList));
        System.out.println("userRatingCount = " + userRatingCount);
        System.out.println("download = " + download);
    }


    //求两个字符串的最大公共字串
    public static  String longestSerialSubstring(String s1,String s2){
        String res = "";

        int m = s1.length(),n = s2.length();
        int[][] dp = new int[m][n];

        int max = 0;
        int index = 0;

        for(int i=0;i<m;i++){
            for(int j=0;j<n;j++){
                char c1 = s1.charAt(i);
                char c2 = s2.charAt(j);

                if(c1==c2){
                    if(i==0 || j==0){
                        dp[i][j] = 1;
                    }else{
                        dp[i][j] = dp[i-1][j-1] + 1;
                    }
                    if(dp[i][j]>max){
                        max = dp[i][j];
                        index = i;
                    }
                }
            }
        }
        res = s1.substring(index-max+1,index+1);
        return res;
    }

}
