#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # # 
# @file  : adn_sdk_pkg_total.sh
# @author: houying
# @date  : 16-11-2
# @desc  : 将etl_adn_sdk_click_daily中package_name不为空的合并到dm_install_list的adn_sdk分区中
# # # # # # # # # # # # # # # # # # # # # #


source ../../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime 1 days ago" "+%Y%m%d")

year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

YESTERDAY=$(date -d "$ScheduleTime 2 days ago" "+%Y%m%d")
old_year=${YESTERDAY:0:4}
old_month=${YESTERDAY:4:2}
old_day=${YESTERDAY:6:2}

INPUT_ADN_SDK_DAILY_PATH="$ETL_ADN_SDK_REQUEST_DAILY/$year/$month/$day"
INPUT_ADN_SDK_TOTAL_PATH="$DM_INSTALL_LIST/$old_year/$old_month/$old_day/adn_request_sdk"
OUTPUT="$DM_INSTALL_LIST/$year/$month/$day/adn_request_sdk"

hadoop fs -rm -r "$OUTPUT"

check_await "${INPUT_ADN_SDK_TOTAL_PATH}/_SUCCESS"

## REDUCE_NUM=$(calculate_reduce_num "${INPUT_ADN_SDK_TOTAL_PATH};${INPUT_ADN_SDK_DAILY_PATH}")

hadoop jar ../../${JAR} mobvista.dmp.datasource.adn.mapreduce.AdnSdkRequestPkgTotalMR \
      -Dmapreduce.map.memory.mb=4096 \
      -Dmapreduce.map.java.opts=-Xmx2458m \
      -Dmapreduce.reduce.memory.mb=4096 \
      -Dmapreduce.reduce.java.opts=-Xmx2458m \
      -Dmapreduce.job.reduces=4000 \
      -Dtask.date=${year}-${month}-${day} \
      -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
      "$INPUT_ADN_SDK_DAILY_PATH" "$INPUT_ADN_SDK_TOTAL_PATH" "$OUTPUT" || exit 1

mount_partition "dm_install_list" "year='$year', month='$month', day='$day', business='adn_request_sdk'" "$OUTPUT"

echo "[Adn Sdk  Request Install End!]"