#!/usr/bin/env bash


source ../../dmp_env.sh

DATE_PATH1=$(date -d "$ScheduleTime 1 days ago" "+%Y/%m/%d")
DATE_PATH2=$(date -d "$ScheduleTime 2 days ago" "+%Y/%m/%d")
DATE_PATH3=$(date -d "$ScheduleTime 3 days ago" "+%Y/%m/%d")
DATE_PATH4=$(date -d "$ScheduleTime 4 days ago" "+%Y/%m/%d")
DATE_PATH5=$(date -d "$ScheduleTime 5 days ago" "+%Y/%m/%d")
DATE_PATH6=$(date -d "$ScheduleTime 6 days ago" "+%Y/%m/%d")
DATE_PATH7=$(date -d "$ScheduleTime 7 days ago" "+%Y/%m/%d")

DATE_PATH="${DATE_PATH1},${DATE_PATH2},${DATE_PATH3},${DATE_PATH4},${DATE_PATH5},${DATE_PATH6},${DATE_PATH7}"

INPUT_ADN_CLICK_PATH="${ETL_ADN_CLICK_DAILY}/{$DATE_PATH}"
INPUT_ADN_PRE_CLICK_PATH="${ETL_ADN_PRE_CLICK_DAILY}/{$DATE_PATH}"
OUTPUT_ADN_MERGE_CLICK="${ETL_ADN_MERGE_CLICK_PRE_CLICK}/${DATE_PATH1}"

hadoop fs -rm -r "$OUTPUT_ADN_MERGE_CLICK"

REDUCE_NUM=$(calculate_reduce_num ${OUTPUT_ADN_MERGE_CLICK})

hadoop jar ../../${JAR} mobvista.dmp.datasource.adn.mapreduce.MergeAdnClickMR \
    -Dmapreduce.job.reduces=1000 \
    -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
    "$INPUT_ADN_CLICK_PATH" "$INPUT_ADN_PRE_CLICK_PATH" "$OUTPUT_ADN_MERGE_CLICK" || exit 1

EXPIRE_PATH="${ETL_ADN_MERGE_CLICK_PRE_CLICK}/$DATE_PATH2"
hadoop fs -test -e $EXPIRE_PATH
if [ $? -eq 0 ];then
  hadoop fs -rm -r $EXPIRE_PATH
fi