#!/usr/bin/env bash

source ../../dmp_env.sh
source ././../../ga_rawdata_analysis/common/tools.sh

dt_today=$(date -d "$ScheduleTime 2 days ago" +"%Y%m%d")
dt_yesterday=$(date -d "$ScheduleTime 3 days ago" +"%Y%m%d")
dt_oneday_ago=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_slash_today=$(date -d "$ScheduleTime 2 days ago" +"%Y/%m/%d")
dt_dash_today=$(date -d "$ScheduleTime 2 days ago" +"%Y-%m-%d")

dt_slash_oneday=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")
check_await "${DM_INSTALL_LIST}_v2/${dt_slash_oneday}/dsp_req/_SUCCESS"


#H_18_IMEI
IMEI_ALIPAYGPHONE_OPPO_GUANGDIANTONG_RES_PATH="${GDT_DATA}/${dt_slash_today}/category=AlipayGphone_oppo_package/business=imei"
#H_18_HASH_IMEI
IMEIMD5_ALIPAYGPHONE_OPPO_GUANGDIANTONG_RES_PATH="${GDT_DATA}/${dt_slash_today}/category=AlipayGphone_oppo_package/business=imeimd5"

#H_18_IMEI append
IMEI_ALIPAYGPHONE_OPPO_GUANGDIANTONG_RES_APPEND_PATH="${GDT_DATA}/${dt_slash_today}/category=AlipayGphone_oppo_package/business=imei_append"
#H_18_HASH_IMEI append
IMEIMD5_ALIPAYGPHONE_OPPO_GUANGDIANTONG_RES_APPEND_PATH="${GDT_DATA}/${dt_slash_today}/category=AlipayGphone_oppo_package/business=imeimd5_append"

#H_18_IMEI delete
IMEI_ALIPAYGPHONE_OPPO_GUANGDIANTONG_RES_DELETE_PATH="${GDT_DATA}/${dt_slash_today}/category=AlipayGphone_oppo_package/business=imei_delete"
#H_18_HASH_IMEI delete
IMEIMD5_ALIPAYGPHONE_OPPO_GUANGDIANTONG_RES_DELETE_PATH="${GDT_DATA}/${dt_slash_today}/category=AlipayGphone_oppo_package/business=imeimd5_delete"



rm -rf guangdiantong_H_18
mkdir guangdiantong_H_18
cd guangdiantong_H_18

ALI_USERINFO_TO_3S_GUANGDIANTONG_RES_PATH="${ALI_USERINFO_TO_3S_GUANGDIANTONG_PATH}/${dt_slash_today}"
#推广点通数据
hadoop fs -test -e ${ALI_USERINFO_TO_3S_GUANGDIANTONG_RES_PATH}
if [ $? -ne 0 ];then
  hadoop fs -mkdir -p ${ALI_USERINFO_TO_3S_GUANGDIANTONG_RES_PATH}
fi


#增加oppo支付宝安装包，为H_18   H_18_IMEI
hadoop fs -text  ${IMEI_ALIPAYGPHONE_OPPO_GUANGDIANTONG_RES_PATH}/* > H_18_IMEI.csv
split -b 160m  H_18_IMEI.csv  -d -a 2 H_18_IMEI_

for new_path in $(ls H_18_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_GUANGDIANTONG_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f H_18_IMEI.csv
#H_18_HASH_IMEI
hadoop fs -text  ${IMEIMD5_ALIPAYGPHONE_OPPO_GUANGDIANTONG_RES_PATH}/* > H_18_HASH_IMEI.csv
split -b 160m  H_18_HASH_IMEI.csv  -d -a 2 H_18_HASH_IMEI_

for new_path in $(ls H_18_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_GUANGDIANTONG_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f H_18_HASH_IMEI.csv



ALI_USERINFO_TO_3S_GUANGDIANTONG_APPEND_RES_PATH="${ALI_USERINFO_TO_3S_GUANGDIANTONG_APPEND_PATH}/${dt_slash_today}"
ALI_USERINFO_TO_3S_GUANGDIANTONG_DELETE_RES_PATH="${ALI_USERINFO_TO_3S_GUANGDIANTONG_DELETE_PATH}/${dt_slash_today}"


#推广点通追加数据
hadoop fs -test -e ${ALI_USERINFO_TO_3S_GUANGDIANTONG_APPEND_RES_PATH}
if [ $? -ne 0 ];then
  hadoop fs -mkdir -p ${ALI_USERINFO_TO_3S_GUANGDIANTONG_APPEND_RES_PATH}
fi

#增加oppo支付宝安装包，为H_18   H_18_IMEI append
hadoop fs -text  ${IMEI_ALIPAYGPHONE_OPPO_GUANGDIANTONG_RES_APPEND_PATH}/* > H_18_IMEI.csv
split -b 160m  H_18_IMEI.csv  -d -a 2 H_18_IMEI_

for new_path in $(ls H_18_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_GUANGDIANTONG_APPEND_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f H_18_IMEI.csv
#H_18_HASH_IMEI   append
hadoop fs -text  ${IMEIMD5_ALIPAYGPHONE_OPPO_GUANGDIANTONG_RES_APPEND_PATH}/* > H_18_HASH_IMEI.csv
split -b 160m  H_18_HASH_IMEI.csv  -d -a 2 H_18_HASH_IMEI_

for new_path in $(ls H_18_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_GUANGDIANTONG_APPEND_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f H_18_HASH_IMEI.csv



#推广点通删除数据
hadoop fs -test -e ${ALI_USERINFO_TO_3S_GUANGDIANTONG_DELETE_RES_PATH}
if [ $? -ne 0 ];then
  hadoop fs -mkdir -p ${ALI_USERINFO_TO_3S_GUANGDIANTONG_DELETE_RES_PATH}
fi

#增加oppo支付宝安装包，为H_18   H_18_IMEI delete
hadoop fs -text  ${IMEI_ALIPAYGPHONE_OPPO_GUANGDIANTONG_RES_DELETE_PATH}/* > H_18_IMEI.csv
split -b 160m  H_18_IMEI.csv  -d -a 2 H_18_IMEI_

for new_path in $(ls H_18_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_GUANGDIANTONG_DELETE_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f H_18_IMEI.csv
#H_18_HASH_IMEI   delete
hadoop fs -text  ${IMEIMD5_ALIPAYGPHONE_OPPO_GUANGDIANTONG_RES_DELETE_PATH}/* > H_18_HASH_IMEI.csv
split -b 160m  H_18_HASH_IMEI.csv  -d -a 2 H_18_HASH_IMEI_

for new_path in $(ls H_18_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_GUANGDIANTONG_DELETE_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f H_18_HASH_IMEI.csv


rm -rf guangdiantong_H_18
echo "good job~~"


