#!/usr/bin/env bash

source ../../dmp_env.sh
source ././../../ga_rawdata_analysis/common/tools.sh

dt_slash_today=$(date -d "$ScheduleTime 2 days ago" +"%Y/%m/%d")
dt_today=$(date -d "$ScheduleTime" +"%Y/%m/%d")

dt_slash_oneday=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")
check_await "${DM_INSTALL_LIST}_v2/${dt_slash_oneday}/dsp_req/_SUCCESS"


#UC_32_IMEI
IMEI_H_32_GUANGDIANTONG_RES_PATH="${GDT_DATA}/${dt_slash_today}/category=ucmobile_oppo_package/business=imei"
#UC_32_HASH_IMEI
IMEIMD5_H_32_GUANGDIANTONG_RES_PATH="${GDT_DATA}/${dt_slash_today}/category=ucmobile_oppo_package/business=imeimd5"

#UC_32_IMEI append
IMEI_H_32_GUANGDIANTONG_RES_APPEND_PATH="${GDT_DATA}/${dt_slash_today}/category=ucmobile_oppo_package/business=imei_append"
#UC_32_HASH_IMEI append
IMEIMD5_H_32_GUANGDIANTONG_RES_APPEND_PATH="${GDT_DATA}/${dt_slash_today}/category=ucmobile_oppo_package/business=imeimd5_append"

#UC_32_IMEI delete
IMEI_H_32_GUANGDIANTONG_RES_DELETE_PATH="${GDT_DATA}/${dt_slash_today}/category=ucmobile_oppo_package/business=imei_delete"
#UC_32_HASH_IMEI delete
IMEIMD5_H_32_GUANGDIANTONG_RES_DELETE_PATH="${GDT_DATA}/${dt_slash_today}/category=ucmobile_oppo_package/business=imeimd5_delete"



rm -rf guangdiantong_UC_32
mkdir guangdiantong_UC_32
cd guangdiantong_UC_32

ALI_USERINFO_TO_3S_UC_RES_PATH="${ALI_USERINFO_TO_3S_UC_PATH}/${dt_today}"
#推广点通数据
hadoop fs -test -e ${ALI_USERINFO_TO_3S_UC_RES_PATH}
if [ $? -ne 0 ];then
  hadoop fs -mkdir -p ${ALI_USERINFO_TO_3S_UC_RES_PATH}
fi


#UC_32_IMEI
hadoop fs -text  ${IMEI_H_32_GUANGDIANTONG_RES_PATH}/* > UC_32_IMEI.csv
split -b 160m  UC_32_IMEI.csv  -d -a 2 UC_32_IMEI_

for new_path in $(ls UC_32_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_UC_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f UC_32_IMEI.csv
#UC_32_HASH_IMEI
hadoop fs -text  ${IMEIMD5_H_32_GUANGDIANTONG_RES_PATH}/* > UC_32_HASH_IMEI.csv
split -b 160m  UC_32_HASH_IMEI.csv  -d -a 2 UC_32_HASH_IMEI_

for new_path in $(ls UC_32_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_UC_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f UC_32_HASH_IMEI.csv

hadoop fs -touchz ${ALI_USERINFO_TO_3S_UC_RES_PATH}/_SUCCESS


ALI_USERINFO_TO_3S_UC_APPEND_RES_PATH="${ALI_USERINFO_TO_3S_UC_APPEND_PATH}/${dt_today}"
ALI_USERINFO_TO_3S_UC_DELETE_RES_PATH="${ALI_USERINFO_TO_3S_UC_DELETE_PATH}/${dt_today}"


#推广点通追加数据
hadoop fs -test -e ${ALI_USERINFO_TO_3S_UC_APPEND_RES_PATH}
if [ $? -ne 0 ];then
  hadoop fs -mkdir -p ${ALI_USERINFO_TO_3S_UC_APPEND_RES_PATH}
fi

#H_32_IMEI append
hadoop fs -text  ${IMEI_H_32_GUANGDIANTONG_RES_APPEND_PATH}/* > UC_32_IMEI.csv
split -b 160m  UC_32_IMEI.csv  -d -a 2 UC_32_IMEI_

for new_path in $(ls UC_32_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_UC_APPEND_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f UC_32_IMEI.csv
#UC_32_HASH_IMEI   append
hadoop fs -text  ${IMEIMD5_H_32_GUANGDIANTONG_RES_APPEND_PATH}/* > UC_32_HASH_IMEI.csv
split -b 160m  UC_32_HASH_IMEI.csv  -d -a 2 UC_32_HASH_IMEI_

for new_path in $(ls UC_32_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_UC_APPEND_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f UC_32_HASH_IMEI.csv

hadoop fs -touchz ${ALI_USERINFO_TO_3S_UC_APPEND_RES_PATH}/_SUCCESS

#推广点通删除数据
hadoop fs -test -e ${ALI_USERINFO_TO_3S_UC_DELETE_RES_PATH}
if [ $? -ne 0 ];then
  hadoop fs -mkdir -p ${ALI_USERINFO_TO_3S_UC_DELETE_RES_PATH}
fi

#UC_32_IMEI delete
hadoop fs -text  ${IMEI_H_32_GUANGDIANTONG_RES_DELETE_PATH}/* > UC_32_IMEI.csv
split -b 160m  UC_32_IMEI.csv  -d -a 2 UC_32_IMEI_

for new_path in $(ls UC_32_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_UC_DELETE_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f UC_32_IMEI.csv
#UC_32_HASH_IMEI   delete
hadoop fs -text  ${IMEIMD5_H_32_GUANGDIANTONG_RES_DELETE_PATH}/* > UC_32_HASH_IMEI.csv
split -b 160m  UC_32_HASH_IMEI.csv  -d -a 2 UC_32_HASH_IMEI_

for new_path in $(ls UC_32_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_UC_DELETE_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f UC_32_HASH_IMEI.csv

hadoop fs -touchz ${ALI_USERINFO_TO_3S_UC_DELETE_RES_PATH}/_SUCCESS

rm -rf guangdiantong_UC_32
echo "good job~~"


