#!/usr/bin/env bash

source ../../dmp_env.sh
source ././../../ga_rawdata_analysis/common/tools.sh

dt_today=$(date -d "$ScheduleTime" +"%Y%m%d")
dt_yesterday=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_oneday_ago=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_slash_today=$(date -d "$ScheduleTime" +"%Y/%m/%d")
dt_dash_today=$(date -d "$ScheduleTime 2 days ago" +"%Y-%m-%d")



#delete
ALI_IMEI_0_UC_LAHUO_DELETE_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo_delete/imei_0"
mount_partition "gdt_data" "day='${dt_today}', category='uc_lahuo_delete', business='imei_0'" "${ALI_IMEI_0_UC_LAHUO_DELETE_SYS_TO3S_PATH}"

ALI_IMEI_1_UC_LAHUO_DELETE_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo_delete/imei_1"
mount_partition "gdt_data" "day='${dt_today}', category='uc_lahuo_delete', business='imei_1'" "${ALI_IMEI_1_UC_LAHUO_DELETE_SYS_TO3S_PATH}"

ALI_IMEI_2_UC_LAHUO_DELETE_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo_delete/imei_2"
mount_partition "gdt_data" "day='${dt_today}', category='uc_lahuo_delete', business='imei_2'" "${ALI_IMEI_2_UC_LAHUO_DELETE_SYS_TO3S_PATH}"

ALI_IMEI_3_UC_LAHUO_DELETE_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo_delete/imei_3"
mount_partition "gdt_data" "day='${dt_today}', category='uc_lahuo_delete', business='imei_3'" "${ALI_IMEI_3_UC_LAHUO_DELETE_SYS_TO3S_PATH}"

ALI_IMEI_4_UC_LAHUO_DELETE_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo_delete/imei_4"
mount_partition "gdt_data" "day='${dt_today}', category='uc_lahuo_delete', business='imei_4'" "${ALI_IMEI_4_UC_LAHUO_DELETE_SYS_TO3S_PATH}"

ALI_IMEI_5_UC_LAHUO_DELETE_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo_delete/imei_5"
mount_partition "gdt_data" "day='${dt_today}', category='uc_lahuo_delete', business='imei_5'" "${ALI_IMEI_5_UC_LAHUO_DELETE_SYS_TO3S_PATH}"

ALI_OAID_2_UC_LAHUO_DELETE_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo_delete/oaid_2"
mount_partition "gdt_data" "day='${dt_today}', category='uc_lahuo_delete', business='oaid_2'" "${ALI_OAID_2_UC_LAHUO_DELETE_SYS_TO3S_PATH}"

ALI_OAID_3_UC_LAHUO_DELETE_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo_delete/oaid_3"
mount_partition "gdt_data" "day='${dt_today}', category='uc_lahuo_delete', business='oaid_3'" "${ALI_OAID_3_UC_LAHUO_DELETE_SYS_TO3S_PATH}"

ALI_OAID_5_UC_LAHUO_DELETE_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo_delete/oaid_5"
mount_partition "gdt_data" "day='${dt_today}', category='uc_lahuo_delete', business='oaid_5'" "${ALI_OAID_5_UC_LAHUO_DELETE_SYS_TO3S_PATH}"

ALI_OAID_6_UC_LAHUO_DELETE_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo_delete/oaid_6"
mount_partition "gdt_data" "day='${dt_today}', category='uc_lahuo_delete', business='oaid_6'" "${ALI_OAID_6_UC_LAHUO_DELETE_SYS_TO3S_PATH}"

HIVE_CMD=$(hive_func)

$HIVE_CMD	-v  -hivevar  dt_today ${dt_today}     -hivevar  dt_yesterday ${dt_yesterday}  -f ali_extract_uc_delete_lahuo_data_to_guangdiantong.sql

if [ $? -ne 0 ];then
  exit 255
fi

rm -rf uc_delete_guangdiantong
mkdir uc_delete_guangdiantong
cd uc_delete_guangdiantong


ALI_USERINFO_TO_3S_UC_DELETE_RES_PATH="${ALI_USERINFO_TO_3S_UC_DELETE_PATH}/${dt_slash_today}"
hadoop fs -rm -r "${ALI_USERINFO_TO_3S_UC_DELETE_RES_PATH}"

#uc拉活推广点通删除数据
hadoop fs -test -e ${ALI_USERINFO_TO_3S_UC_DELETE_RES_PATH}
if [ $? -ne 0 ];then
  hadoop fs -mkdir -p ${ALI_USERINFO_TO_3S_UC_DELETE_RES_PATH}
fi

#imei
hadoop fs -text  ${ALI_IMEI_0_UC_LAHUO_DELETE_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 UC_0_HASH_IMEI_
for new_path in $(ls UC_0_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_UC_DELETE_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv

hadoop fs -text  ${ALI_IMEI_1_UC_LAHUO_DELETE_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 UC_1_HASH_IMEI_
for new_path in $(ls UC_1_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_UC_DELETE_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv

hadoop fs -text  ${ALI_IMEI_2_UC_LAHUO_DELETE_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 UC_2_HASH_IMEI_
for new_path in $(ls UC_2_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_UC_DELETE_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv

hadoop fs -text  ${ALI_IMEI_3_UC_LAHUO_DELETE_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 UC_3_HASH_IMEI_
for new_path in $(ls UC_3_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_UC_DELETE_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv

hadoop fs -text  ${ALI_IMEI_4_UC_LAHUO_DELETE_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 UC_4_HASH_IMEI_
for new_path in $(ls UC_4_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_UC_DELETE_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv

hadoop fs -text  ${ALI_IMEI_5_UC_LAHUO_DELETE_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 UC_5_HASH_IMEI_
for new_path in $(ls UC_5_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_UC_DELETE_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv

#oaid

hadoop fs -text  ${ALI_OAID_2_UC_LAHUO_DELETE_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 UC_2_HASH_OAID_
for new_path in $(ls UC_2_HASH_OAID_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_UC_DELETE_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv

hadoop fs -text  ${ALI_OAID_3_UC_LAHUO_DELETE_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 UC_3_HASH_OAID_
for new_path in $(ls UC_3_HASH_OAID_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_UC_DELETE_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv

hadoop fs -text  ${ALI_OAID_5_UC_LAHUO_DELETE_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 UC_5_HASH_OAID_
for new_path in $(ls UC_5_HASH_OAID_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_UC_DELETE_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv

hadoop fs -text  ${ALI_OAID_6_UC_LAHUO_DELETE_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 UC_6_HASH_OAID_
for new_path in $(ls UC_6_HASH_OAID_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_UC_DELETE_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv

#hadoop fs -touchz ${ALI_USERINFO_TO_3S_UC_DELETE_RES_PATH}/_SUCCESS

rm -rf uc_delete_guangdiantong
echo "good job~~"


