#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @file    :app_tree_tag.sh
# @desc    :app_tree_tag job
# # # # # # # # # # # # # # # # # # # # # #

date_path=$(date -d "$ScheduleTime" +"%Y/%m/%d")

base_dir=`pwd`

output_file="${base_dir}/package_tag_tmp.txt"

mysql -h dataplatform-app-tag.c5yzcdreb1xr.us-east-1.rds.amazonaws.com -P 3306 -D app_tag -u apptag_rw -p'7gyLEVtkER3u8c9' -e 'SELECT DISTINCT package_name,first_tag,second_tag,third_tag,platform FROM app_tag.tree_tag_list' > ${output_file}

sed -i '1d' ${output_file}

final_file="${base_dir}/package_tag.txt"

sed -e 's/\t/,/g' ${output_file} >> ${final_file} &

if [ $? -ne 0 ];then
  exit 255
fi

dmp_package_tag_to_mongo_path="s3://mob-emr-test/dataplatform/dmp_package_tag/"

hadoop dfs -put -f ${final_file} ${dmp_package_tag_to_mongo_path}
if [ $? -ne 0 ];then
  exit 255
fi

rm -r $output_file

rm -r $final_file

output_file="${base_dir}/package_tag_tmp.txt"

mysql -h dataplatform-app-tag.c5yzcdreb1xr.us-east-1.rds.amazonaws.com -P 3306 -D app_tag -u apptag_rw -p'7gyLEVtkER3u8c9' -e 'SELECT DISTINCT package_name,platform,first_tag,second_tag,third_tag FROM app_tag.tree_tag_list' > ${output_file}

# ALTER TABLE dwh.dmp_package_tag ADD COLUMN (platform String) AFTER package_name;
sed -i '1d' ${output_file}

final_file="${base_dir}/package_tag.txt"

sed -e 's/\t/,/g' ${output_file} >> ${final_file} &

if [ $? -ne 0 ];then
  exit 255
fi

dmp_package_tag_path="s3://mob-emr-test/dataplatform/datawarehourse/dwh/dmp_package_tag/${date_path}"

hadoop fs -test -e ${dmp_package_tag_path}
if [ $? -ne 0 ];then
  hadoop fs -mkdir -p ${dmp_package_tag_path}
fi

hadoop dfs -put -f ${final_file} ${dmp_package_tag_path}
if [ $? -ne 0 ];then
  exit 255
fi

export HIVE_CONF_DIR=/data/azkaban-hadoop/command-home/hive-offline/conf

hive -e "ALTER TABLE dwh.dmp_package_tag SET LOCATION '${dmp_package_tag_path}';"
if [ $? -ne 0 ];then
  exit 255
fi
