#!/bin/bash

source ../dmp_env.sh

BUSINESS=$1
DAY=$2
PARTITION=$3
COALESCE=$4
EXECUTOR=$5

LOG_TIME=$(date +%Y%m%d -d "-${DAY} day $ScheduleTime")
date_path=$(date +"%Y/%m/%d" -d "-${DAY} day ${ScheduleTime}")

INPUT="${DM_INSTALL_LIST}_v2/${date_path}/${BUSINESS}"

check_await ${INPUT}/_SUCCESS

OUTPUT="${DMP_INSTALL_LIST}/${date_path}/${BUSINESS}"

expire_date=$(date +%Y%m%d -d "-4 day $LOG_TIME")
expire_date_path=$(date +"%Y/%m/%d" -d "-4 day ${LOG_TIME}")
EXPIRE_OUTPUT_PATH="${DMP_INSTALL_LIST}/${expire_date_path}/${BUSINESS}"

spark-submit --class mobvista.dmp.common.Old2NewInstallList \
     --name "Old2NewInstallList.${BUSINESS}.${LOG_TIME}" \
     --conf spark.sql.shuffle.partitions=${PARTITION} \
     --conf spark.default.parallelism=${PARTITION} \
     --conf spark.kryoserializer.buffer.max=256m \
     --conf spark.executor.extraJavaOptions="-XX:+UseG1GC" \
     --files ${HIVE_SITE_PATH} \
     --master yarn --deploy-mode cluster --executor-memory 4g --driver-memory 4g  --executor-cores 2  --num-executors ${EXECUTOR} \
     ../${JAR} -date ${LOG_TIME} -business ${BUSINESS} -output ${OUTPUT}  -coalesce ${COALESCE}

if [[ $? -ne 0 ]];then
  exit 255
fi

mount_partition "dmp_install_list" "dt='$LOG_TIME', business='$BUSINESS'" "$OUTPUT"

# 删除过期的分区及删除对应路径
unmount_partition "dmp_install_list" "dt='${expire_date}', business='${BUSINESS}'" "${EXPIRE_OUTPUT_PATH}"