#!/usr/bin/env bash

source ../dmp_env.sh
source ././../ga_rawdata_analysis/common/tools.sh

dt_today=$(date -d "$ScheduleTime 3 days ago" +"%Y%m%d")
dt_dash_today=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")


HIVE_CMD=$(hive_func)

$HIVE_CMD	-v  -hivevar  dt_today ${dt_today}    -f	 gambling_chess_RT.sql

check_await "${TMP_EGGPLANTS_OUTPUT_PATH}/${dt_dash_today}"

hadoop fs -test -e "${ODS_OTHER_DEVICE_DAILY}/${dt_dash_today}"
if [ $? -ne 0 ];then
  hadoop fs -mkdir -p "${ODS_OTHER_DEVICE_DAILY}/${dt_dash_today}"
fi

hadoop distcp -m10  "${TMP_EGGPLANTS_RT_WEEKLY_OUTPUT_PATH}/dt=${dt_today}/*" "${TMP_EGGPLANTS_OUTPUT_PATH}/${dt_dash_today}/"
hadoop distcp -m10  "${ODS_OTHER_DEVICE_RT_WEEKLY}/dt=${dt_today}/*" "${ODS_OTHER_DEVICE_DAILY}/${dt_dash_today}/"
