set mapreduce.map.memory.mb=2048;
set mapreduce.reduce.memory.mb=3072;
set mapreduce.map.memory.mb=2048;
set mapreduce.reduce.memory.mb=3072;

insert overwrite table dwh.etl_3s_postback_event_daily
select idfa,
md5_idfa,
gaid,
uuid,
md5_gaid,
lower(pl) platform,
lower(app_id) package_name,
country,
event_name,
event_value,
event_time,
install_time,
yyyymmdd update_date,
`type`
from dwh.ods_adn_trackingnew_postback_event where concat(yyyy,mm,dd) = '${today}' and  coalesce(idfa,gaid) !='0'  and type in ('appsflyer','min_appsflyer','tenjin')
and event_name is not null
and ( ( gaid rlike '^[0-9a-fA-F]{8}(-[0-9a-fA-F]{4}){3}-[0-9a-fA-F]{12}$' and gaid !='00000000-0000-0000-0000-000000000000') or (idfa rlike '^[0-9a-fA-F]{8}(-[0-9a-fA-F]{4}){3}-[0-9a-fA-F]{12}$' and idfa != '00000000-0000-0000-0000-000000000000'))
and app_id is not null
group by
idfa,
md5_idfa,
gaid,
uuid,
md5_gaid,
lower(pl),
lower(app_id),
country,
event_name,
event_value,
event_time,
install_time,
yyyymmdd,
`type`;


insert overwrite table dwh.3s_postback_event_device_md5
select coalesce(md5_idfa,md5_gaid) device_id_md5 from dwh.etl_3s_postback_event_daily group by coalesce(md5_idfa,md5_gaid);



insert overwrite table dwh.etl_3s_postback_event_md5
select /*+ MAPJOIN(a) */ b.device_id,a.device_id_md5
from  dwh.3s_postback_event_device_md5 a join
(select * from dwh.device_id_md5_match where dt='${last_sunday}' and device_type in ('gaid','idfa')) b
on a.device_id_md5=b.device_id_md5
group by b.device_id,a.device_id_md5;


INSERT  overwrite table  dwh.ods_dmp_event_org_pre
select
a.type,
a.uuid,
coalesce(a.device_id,b.device_id) device_id,
a.device_type,
a.platform,
a.package_name,
a.country,
a.event_name,
a.event_value,
a.event_time,
a.install_time,
a.update_date
from (
select case when platform = 'ios' and idfa is not null then idfa when platform = 'android' and gaid is not null then gaid end as device_id,
case when platform = 'ios' and idfa is null then md5_idfa when platform = 'android' and gaid is null then md5_gaid end as device_id_md5,
case when platform = 'ios'then 'idfa' when platform = 'android'then 'gaid' end as device_type,
platform,
case when instr(package_name,'id') = 1 then substr(package_name,3) else package_name end as package_name,
country,
event_name,
event_value,
event_time,
install_time,
update_date,
uuid,
type
from dwh.etl_3s_postback_event_daily ) a left join (select * from dwh.etl_3s_postback_event_md5 where device_id is not null) b on (a.device_id_md5=b.device_id_md5)


INSERT overwrite table dwh.ods_dmp_event_org partition(dt='${today}',business='allpb')
select
a.type,
a.uuid,
a.device_id,
a.device_type,
a.platform,
a.package_name,
a.country,
a.event_name,
a.event_value,
a.event_time,
t3.first_tag,
t3.second_tag,
case when d.event_name is null then '0'  else '1' end as pursub,
a.install_time,
a.update_date
from dwh.ods_dmp_event_org_pre a join  dwh.dim_package_tags_combine t3 on(a.package_name = t3.package_name)
LEFT  JOIN dwh.adv_event_name_tab d on (lower(a.event_name) = lower(d.event_name))
group by
a.type,
a.uuid,
a.device_id,
a.device_type,
a.platform,
a.package_name,
a.country,
a.event_name,
a.event_value,
a.event_time,
t3.first_tag,
t3.second_tag,
case when d.event_name is null then '0'  else '1' end,
a.install_time,
a.update_date;