set mapreduce.map.memory.mb=3072;
set mapreduce.reduce.memory.mb=4096;
set mapreduce.map.memory.mb=3072;
set mapreduce.reduce.memory.mb=4096;
 set mapred.max.split.size=536870912;
 set mapred.min.split.size.per.node=536870912;
 set mapred.min.split.size.per.rack=536870912;

insert overwrite table dwh.etl_3s_postback_event_daily
select
X.device_id,
X.device_id_md5,
X.uuid,
X.platform,
X.package_name,
X.country,
X.event_name,
X.event_value,
X.event_time,
X.install_time,
X.update_date,
X.type
from
(select
gaid  device_id,
md5_gaid device_id_md5,
uuid,
lower(pl) platform,
app_id package_name,
country,
event_name,
event_value,
event_time,
install_time,
`date` update_date,
type
from dwh.ods_adn_trackingnew_postback_event  where  concat(yyyy,mm,dd) = '${today}'  and  type in ('appsflyer','min_appsflyer','tenjin','adjust')
and (gaid rlike '^[0-9a-fA-F]{8}(-[0-9a-fA-F]{4}){3}-[0-9a-fA-F]{12}$' and gaid !='00000000-0000-0000-0000-000000000000'
or md5_gaid rlike '^([a-fA-F0-9]{32})$')
and event_name is not null
and app_id is not null
union all
select idfa device_id,
md5_idfa device_id_md5,
uuid,
lower(pl) platform,
app_id package_name,
country,
event_name,
event_value,
event_time,
install_time,
`date` update_date,
type
from dwh.ods_adn_trackingnew_postback_event  where  concat(yyyy,mm,dd) = '${today}'  and  type in ('appsflyer','min_appsflyer','tenjin','adjust')
and (idfa rlike '^[0-9a-fA-F]{8}(-[0-9a-fA-F]{4}){3}-[0-9a-fA-F]{12}$' and idfa !='00000000-0000-0000-0000-000000000000'
or md5_idfa rlike '^([a-fA-F0-9]{32})$')
and event_name is not null
and app_id is not null ) X
group by
X.device_id,
X.device_id_md5,
X.uuid,
X.platform,
X.package_name,
X.country,
X.event_name,
X.event_value,
X.event_time,
X.install_time,
X.update_date,
X.type;


insert overwrite table dwh.3s_postback_event_device_md5
select device_id_md5 from dwh.etl_3s_postback_event_daily where device_id_md5 is not null group by device_id_md5;



insert overwrite table dwh.etl_3s_postback_event_md5
select  /*+ MAPJOIN(a) */  b.device_id,a.device_id_md5
from  dwh.3s_postback_event_device_md5 a join
(select * from dwh.device_id_md5_match where dt='${last_sunday}' and device_type in ('gaid','idfa')  ) b
on a.device_id_md5=b.device_id_md5
group by b.device_id,a.device_id_md5;

set mapreduce.job.reduces=300;

INSERT  overwrite table  dwh.ods_dmp_event_org_pre
select
a.type,
a.uuid,
case when a.device_id rlike '^[0-9a-fA-F]{8}(-[0-9a-fA-F]{4}){3}-[0-9a-fA-F]{12}$' and a.device_id !='00000000-0000-0000-0000-000000000000' then a.device_id
else b.device_id end as device_id,
case when a.platform = 'ios'then 'idfa' when a.platform = 'android'then 'gaid' end as device_type,
a.platform,
case when instr(a.package_name,'id') = 1 then substr(a.package_name,3) else a.package_name end as package_name,
a.country,
a.event_name,
a.event_value,
a.event_time,
a.install_time,
a.update_date
from  dwh.etl_3s_postback_event_daily a left join dwh.etl_3s_postback_event_md5 b on (a.device_id_md5=b.device_id_md5);


INSERT overwrite table dwh.ods_dmp_event_org partition(dt='${today}',business='allpb')
select
a.type,
a.uuid,
a.device_id,
a.device_type,
a.platform,
a.package_name,
a.country,
a.event_name,
a.event_value,
a.event_time,
t3.first_tag,
t3.second_tag,
case when d.event_name is null then '0'  else '1' end as pursub,
a.install_time,
a.update_date
from dwh.ods_dmp_event_org_pre a join  dwh.dim_package_tags_combine t3 on(a.package_name = t3.package_name)
LEFT  JOIN dwh.adv_event_name_tab d on (lower(a.event_name) = lower(d.event_name))
group by
a.type,
a.uuid,
a.device_id,
a.device_type,
a.platform,
a.package_name,
a.country,
a.event_name,
a.event_value,
a.event_time,
t3.first_tag,
t3.second_tag,
case when d.event_name is null then '0'  else '1' end,
a.install_time,
a.update_date;