#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # # 
# @file  : ga_interest_subtract.sh
# @author: houying
# @date  : 16-11-25
# # # # # # # # # # # # # # # # # # # # # # 

source ../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime 1 days ago" "+%Y%m%d")

year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

YESTERDAY=$(date -d "$ScheduleTime 2 days ago" "+%Y%m%d")
old_year=${YESTERDAY:0:4}
old_month=${YESTERDAY:4:2}
old_day=${YESTERDAY:6:2}

THREE_DAYS_AGO=$(date -d "$ScheduleTime 3 days ago" "+%Y%m%d")
older_year=${YESTERDAY:0:4}
older_month=${YESTERDAY:4:2}
older_day=${YESTERDAY:6:2}

INPUT_GA_INTEREST_PATH="$DM_INTEREST_PATH/$year/$month/$day/ga"
INPUT_GA_DEVICE_PATH="$GA_ACTIVE_TOTAL_PATH/$old_year/$old_month/$old_day"
OUTPUT_PATH="$DM_INTEREST_PATH/$old_year/$old_month/$old_day/ga_device"

hadoop fs -rm -r "$OUTPUT_PATH"

REDUCE_NUM=$(calculate_reduce_num "${INPUT_GA_DEVICE_PATH};${INPUT_GA_INTEREST_PATH}")


hadoop jar ../${JAR} mobvista.dmp.datasource.ga.mapreduce.GaSubtractInterestMR \
    -Dmapreduce.job.reduces=${REDUCE_NUM} \
    -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
    "$INPUT_GA_INTEREST_PATH" "$INPUT_GA_DEVICE_PATH" "$OUTPUT_PATH" || exit 1

if [ $? -ne 0 ]; then
    exit 255
fi

mount_partition "dm_interest_tag" "year='$year', month='$month', day='$day', business='ga_device'"  \
    "$OUTPUT_PATH" || exit 1

echo "[Ga Interest Subtract End!]"