use emr_doppler;
set hive.exec.compress.output=true;
set mapred.output.compression.codec=org.apache.hadoop.io.compress.GzipCodec;
set mapreduce.map.memory.mb=2048;
set mapreduce.reduce.memory.mb=3072;
set mapred.reduce.tasks=200;

DROP TABLE revenue_${date_str_undline};
CREATE TABLE IF NOT EXISTS revenue_${date_str_undline}
(
    game_id   int,
    user_id   string,
    player_id string,
    revenue   string
) row format delimited  fields terminated by '|'
    location 's3://mob-emr-test/dataplatform/emr/${prefix}/revenue/';

INSERT OVERWRITE table revenue_${date_str_undline}
SELECT game_id, user_id, player_id, MAX(revenue)
FROM event_${date_str_undline}
WHERE revenue like '%AED%'
   or revenue like '%AFN%'
   or revenue like '%ALL%'
   or revenue like '%AMD%'
   or revenue like '%ANG%'
   or revenue like '%AOA%'
   or revenue like '%ARS%'
   or revenue like '%AUD%'
   or revenue like '%AWG%'
   or revenue like '%AZN%'
   or revenue like '%BAM%'
   or revenue like '%BBD%'
   or revenue like '%BDT%'
   or revenue like '%BGN%'
   or revenue like '%BHD%'
   or revenue like '%BIF%'
   or revenue like '%BMD%'
   or revenue like '%BND%'
   or revenue like '%BOB%'
   or revenue like '%BRL%'
   or revenue like '%BSD%'
   or revenue like '%BTC%'
   or revenue like '%BTN%'
   or revenue like '%BWP%'
   or revenue like '%BYR%'
   or revenue like '%BZD%'
   or revenue like '%CAD%'
   or revenue like '%CDF%'
   or revenue like '%CHF%'
   or revenue like '%CLF%'
   or revenue like '%CLP%'
   or revenue like '%CNY%'
   or revenue like '%COP%'
   or revenue like '%CRC%'
   or revenue like '%CUP%'
   or revenue like '%CVE%'
   or revenue like '%CZK%'
   or revenue like '%DJF%'
   or revenue like '%DKK%'
   or revenue like '%DOP%'
   or revenue like '%DZD%'
   or revenue like '%EEK%'
   or revenue like '%EGP%'
   or revenue like '%ETB%'
   or revenue like '%EUR%'
   or revenue like '%FJD%'
   or revenue like '%FKP%'
   or revenue like '%GBP%'
   or revenue like '%GEL%'
   or revenue like '%GHS%'
   or revenue like '%GIP%'
   or revenue like '%GMD%'
   or revenue like '%GNF%'
   or revenue like '%GTQ%'
   or revenue like '%GYD%'
   or revenue like '%HKD%'
   or revenue like '%HNL%'
   or revenue like '%HRK%'
   or revenue like '%HTG%'
   or revenue like '%HUF%'
   or revenue like '%IDR%'
   or revenue like '%ILS%'
   or revenue like '%INR%'
   or revenue like '%IQD%'
   or revenue like '%IRR%'
   or revenue like '%ISK%'
   or revenue like '%JEP%'
   or revenue like '%JMD%'
   or revenue like '%JOD%'
   or revenue like '%JPY%'
   or revenue like '%KES%'
   or revenue like '%KGS%'
   or revenue like '%KHR%'
   or revenue like '%KMF%'
   or revenue like '%KPW%'
   or revenue like '%KRW%'
   or revenue like '%KWD%'
   or revenue like '%KYD%'
   or revenue like '%KZT%'
   or revenue like '%LAK%'
   or revenue like '%LBP%'
   or revenue like '%LKR%'
   or revenue like '%LRD%'
   or revenue like '%LSL%'
   or revenue like '%LTL%'
   or revenue like '%LVL%'
   or revenue like '%LYD%'
   or revenue like '%MAD%'
   or revenue like '%MDL%'
   or revenue like '%MGA%'
   or revenue like '%MKD%'
   or revenue like '%MMK%'
   or revenue like '%MNT%'
   or revenue like '%MOP%'
   or revenue like '%MRO%'
   or revenue like '%MTL%'
   or revenue like '%MUR%'
   or revenue like '%MVR%'
   or revenue like '%MWK%'
   or revenue like '%MXN%'
   or revenue like '%MYR%'
   or revenue like '%MZN%'
   or revenue like '%NAD%'
   or revenue like '%NGN%'
   or revenue like '%NIO%'
   or revenue like '%NOK%'
   or revenue like '%NPR%'
   or revenue like '%NZD%'
   or revenue like '%OMR%'
   or revenue like '%PAB%'
   or revenue like '%PEN%'
   or revenue like '%PGK%'
   or revenue like '%PHP%'
   or revenue like '%PKR%'
   or revenue like '%PLN%'
   or revenue like '%PYG%'
   or revenue like '%QAR%'
   or revenue like '%RON%'
   or revenue like '%RSD%'
   or revenue like '%RUB%'
   or revenue like '%RWF%'
   or revenue like '%SAR%'
   or revenue like '%SBD%'
   or revenue like '%SCR%'
   or revenue like '%SDG%'
   or revenue like '%SEK%'
   or revenue like '%SGD%'
   or revenue like '%SHP%'
   or revenue like '%SLL%'
   or revenue like '%SOS%'
   or revenue like '%SRD%'
   or revenue like '%STD%'
   or revenue like '%SVC%'
   or revenue like '%SYP%'
   or revenue like '%SZL%'
   or revenue like '%THB%'
   or revenue like '%TJS%'
   or revenue like '%TMT%'
   or revenue like '%TND%'
   or revenue like '%TOP%'
   or revenue like '%TRY%'
   or revenue like '%TTD%'
   or revenue like '%TWD%'
   or revenue like '%TZS%'
   or revenue like '%UAH%'
   or revenue like '%UGX%'
   or revenue like '%USD%'
   or revenue like '%UYU%'
   or revenue like '%UZS%'
   or revenue like '%VEF%'
   or revenue like '%VND%'
   or revenue like '%VUV%'
   or revenue like '%WST%'
   or revenue like '%XAF%'
   or revenue like '%XAG%'
   or revenue like '%XAU%'
   or revenue like '%XCD%'
   or revenue like '%XDR%'
   or revenue like '%XOF%'
   or revenue like '%XPF%'
   or revenue like '%YER%'
   or revenue like '%ZAR%'
   or revenue like '%ZMK%'
   or revenue like '%ZMW%'
   or revenue like '%ZWL%'
   or revenue like '%aed%'
   or revenue like '%afn%'
   or revenue like '%all%'
   or revenue like '%amd%'
   or revenue like '%ang%'
   or revenue like '%aoa%'
   or revenue like '%ars%'
   or revenue like '%aud%'
   or revenue like '%awg%'
   or revenue like '%azn%'
   or revenue like '%bam%'
   or revenue like '%bbd%'
   or revenue like '%bdt%'
   or revenue like '%bgn%'
   or revenue like '%bhd%'
   or revenue like '%bif%'
   or revenue like '%bmd%'
   or revenue like '%bnd%'
   or revenue like '%bob%'
   or revenue like '%brl%'
   or revenue like '%bsd%'
   or revenue like '%btc%'
   or revenue like '%btn%'
   or revenue like '%bwp%'
   or revenue like '%byr%'
   or revenue like '%bzd%'
   or revenue like '%cad%'
   or revenue like '%cdf%'
   or revenue like '%chf%'
   or revenue like '%clf%'
   or revenue like '%clp%'
   or revenue like '%cny%'
   or revenue like '%cop%'
   or revenue like '%crc%'
   or revenue like '%cup%'
   or revenue like '%cve%'
   or revenue like '%czk%'
   or revenue like '%djf%'
   or revenue like '%dkk%'
   or revenue like '%dop%'
   or revenue like '%dzd%'
   or revenue like '%eek%'
   or revenue like '%egp%'
   or revenue like '%etb%'
   or revenue like '%eur%'
   or revenue like '%fjd%'
   or revenue like '%fkp%'
   or revenue like '%gbp%'
   or revenue like '%gel%'
   or revenue like '%ghs%'
   or revenue like '%gip%'
   or revenue like '%gmd%'
   or revenue like '%gnf%'
   or revenue like '%gtq%'
   or revenue like '%gyd%'
   or revenue like '%hkd%'
   or revenue like '%hnl%'
   or revenue like '%hrk%'
   or revenue like '%htg%'
   or revenue like '%huf%'
   or revenue like '%idr%'
   or revenue like '%ils%'
   or revenue like '%inr%'
   or revenue like '%iqd%'
   or revenue like '%irr%'
   or revenue like '%isk%'
   or revenue like '%jep%'
   or revenue like '%jmd%'
   or revenue like '%jod%'
   or revenue like '%jpy%'
   or revenue like '%kes%'
   or revenue like '%kgs%'
   or revenue like '%khr%'
   or revenue like '%kmf%'
   or revenue like '%kpw%'
   or revenue like '%krw%'
   or revenue like '%kwd%'
   or revenue like '%kyd%'
   or revenue like '%kzt%'
   or revenue like '%lak%'
   or revenue like '%lbp%'
   or revenue like '%lkr%'
   or revenue like '%lrd%'
   or revenue like '%lsl%'
   or revenue like '%ltl%'
   or revenue like '%lvl%'
   or revenue like '%lyd%'
   or revenue like '%mad%'
   or revenue like '%mdl%'
   or revenue like '%mga%'
   or revenue like '%mkd%'
   or revenue like '%mmk%'
   or revenue like '%mnt%'
   or revenue like '%mop%'
   or revenue like '%mro%'
   or revenue like '%mtl%'
   or revenue like '%mur%'
   or revenue like '%mvr%'
   or revenue like '%mwk%'
   or revenue like '%mxn%'
   or revenue like '%myr%'
   or revenue like '%mzn%'
   or revenue like '%nad%'
   or revenue like '%ngn%'
   or revenue like '%nio%'
   or revenue like '%nok%'
   or revenue like '%npr%'
   or revenue like '%nzd%'
   or revenue like '%omr%'
   or revenue like '%pab%'
   or revenue like '%pen%'
   or revenue like '%pgk%'
   or revenue like '%php%'
   or revenue like '%pkr%'
   or revenue like '%pln%'
   or revenue like '%pyg%'
   or revenue like '%qar%'
   or revenue like '%ron%'
   or revenue like '%rsd%'
   or revenue like '%rub%'
   or revenue like '%rwf%'
   or revenue like '%sar%'
   or revenue like '%sbd%'
   or revenue like '%scr%'
   or revenue like '%sdg%'
   or revenue like '%sek%'
   or revenue like '%sgd%'
   or revenue like '%shp%'
   or revenue like '%sll%'
   or revenue like '%sos%'
   or revenue like '%srd%'
   or revenue like '%std%'
   or revenue like '%svc%'
   or revenue like '%syp%'
   or revenue like '%szl%'
   or revenue like '%thb%'
   or revenue like '%tjs%'
   or revenue like '%tmt%'
   or revenue like '%tnd%'
   or revenue like '%top%'
   or revenue like '%try%'
   or revenue like '%ttd%'
   or revenue like '%twd%'
   or revenue like '%tzs%'
   or revenue like '%uah%'
   or revenue like '%ugx%'
   or revenue like '%usd%'
   or revenue like '%uyu%'
   or revenue like '%uzs%'
   or revenue like '%vef%'
   or revenue like '%vnd%'
   or revenue like '%vuv%'
   or revenue like '%wst%'
   or revenue like '%xaf%'
   or revenue like '%xag%'
   or revenue like '%xau%'
   or revenue like '%xcd%'
   or revenue like '%xdr%'
   or revenue like '%xof%'
   or revenue like '%xpf%'
   or revenue like '%yer%'
   or revenue like '%zar%'
   or revenue like '%zmk%'
   or revenue like '%zmw%'
   or revenue like '%zwl%'
GROUP BY game_id, user_id, player_id;

set mapred.map.tasks=100;
set mapred.reduce.tasks=100;

INSERT overwrite table dim_player_is_payer
SELECT game_id, player_id AS player_id, true as is_payer
FROM revenue_${date_str_undline}
WHERE get_json_object(revenue, '$.aed') > 0
   or get_json_object(revenue, '$.afn') > 0
   or get_json_object(revenue, '$.all') > 0
   or get_json_object(revenue, '$.amd') > 0
   or get_json_object(revenue, '$.ang') > 0
   or get_json_object(revenue, '$.aoa') > 0
   or get_json_object(revenue, '$.ars') > 0
   or get_json_object(revenue, '$.aud') > 0
   or get_json_object(revenue, '$.awg') > 0
   or get_json_object(revenue, '$.azn') > 0
   or get_json_object(revenue, '$.bam') > 0
   or get_json_object(revenue, '$.bbd') > 0
   or get_json_object(revenue, '$.bdt') > 0
   or get_json_object(revenue, '$.bgn') > 0
   or get_json_object(revenue, '$.bhd') > 0
   or get_json_object(revenue, '$.bif') > 0
   or get_json_object(revenue, '$.bmd') > 0
   or get_json_object(revenue, '$.bnd') > 0
   or get_json_object(revenue, '$.bob') > 0
   or get_json_object(revenue, '$.brl') > 0
   or get_json_object(revenue, '$.bsd') > 0
   or get_json_object(revenue, '$.btc') > 0
   or get_json_object(revenue, '$.btn') > 0
   or get_json_object(revenue, '$.bwp') > 0
   or get_json_object(revenue, '$.byr') > 0
   or get_json_object(revenue, '$.bzd') > 0
   or get_json_object(revenue, '$.cad') > 0
   or get_json_object(revenue, '$.cdf') > 0
   or get_json_object(revenue, '$.chf') > 0
   or get_json_object(revenue, '$.clf') > 0
   or get_json_object(revenue, '$.clp') > 0
   or get_json_object(revenue, '$.cny') > 0
   or get_json_object(revenue, '$.cop') > 0
   or get_json_object(revenue, '$.crc') > 0
   or get_json_object(revenue, '$.cup') > 0
   or get_json_object(revenue, '$.cve') > 0
   or get_json_object(revenue, '$.czk') > 0
   or get_json_object(revenue, '$.djf') > 0
   or get_json_object(revenue, '$.dkk') > 0
   or get_json_object(revenue, '$.dop') > 0
   or get_json_object(revenue, '$.dzd') > 0
   or get_json_object(revenue, '$.eek') > 0
   or get_json_object(revenue, '$.egp') > 0
   or get_json_object(revenue, '$.etb') > 0
   or get_json_object(revenue, '$.eur') > 0
   or get_json_object(revenue, '$.fjd') > 0
   or get_json_object(revenue, '$.fkp') > 0
   or get_json_object(revenue, '$.gbp') > 0
   or get_json_object(revenue, '$.gel') > 0
   or get_json_object(revenue, '$.ghs') > 0
   or get_json_object(revenue, '$.gip') > 0
   or get_json_object(revenue, '$.gmd') > 0
   or get_json_object(revenue, '$.gnf') > 0
   or get_json_object(revenue, '$.gtq') > 0
   or get_json_object(revenue, '$.gyd') > 0
   or get_json_object(revenue, '$.hkd') > 0
   or get_json_object(revenue, '$.hnl') > 0
   or get_json_object(revenue, '$.hrk') > 0
   or get_json_object(revenue, '$.htg') > 0
   or get_json_object(revenue, '$.huf') > 0
   or get_json_object(revenue, '$.idr') > 0
   or get_json_object(revenue, '$.ils') > 0
   or get_json_object(revenue, '$.inr') > 0
   or get_json_object(revenue, '$.iqd') > 0
   or get_json_object(revenue, '$.irr') > 0
   or get_json_object(revenue, '$.isk') > 0
   or get_json_object(revenue, '$.jep') > 0
   or get_json_object(revenue, '$.jmd') > 0
   or get_json_object(revenue, '$.jod') > 0
   or get_json_object(revenue, '$.jpy') > 0
   or get_json_object(revenue, '$.kes') > 0
   or get_json_object(revenue, '$.kgs') > 0
   or get_json_object(revenue, '$.khr') > 0
   or get_json_object(revenue, '$.kmf') > 0
   or get_json_object(revenue, '$.kpw') > 0
   or get_json_object(revenue, '$.krw') > 0
   or get_json_object(revenue, '$.kwd') > 0
   or get_json_object(revenue, '$.kyd') > 0
   or get_json_object(revenue, '$.kzt') > 0
   or get_json_object(revenue, '$.lak') > 0
   or get_json_object(revenue, '$.lbp') > 0
   or get_json_object(revenue, '$.lkr') > 0
   or get_json_object(revenue, '$.lrd') > 0
   or get_json_object(revenue, '$.lsl') > 0
   or get_json_object(revenue, '$.ltl') > 0
   or get_json_object(revenue, '$.lvl') > 0
   or get_json_object(revenue, '$.lyd') > 0
   or get_json_object(revenue, '$.mad') > 0
   or get_json_object(revenue, '$.mdl') > 0
   or get_json_object(revenue, '$.mga') > 0
   or get_json_object(revenue, '$.mkd') > 0
   or get_json_object(revenue, '$.mmk') > 0
   or get_json_object(revenue, '$.mnt') > 0
   or get_json_object(revenue, '$.mop') > 0
   or get_json_object(revenue, '$.mro') > 0
   or get_json_object(revenue, '$.mtl') > 0
   or get_json_object(revenue, '$.mur') > 0
   or get_json_object(revenue, '$.mvr') > 0
   or get_json_object(revenue, '$.mwk') > 0
   or get_json_object(revenue, '$.mxn') > 0
   or get_json_object(revenue, '$.myr') > 0
   or get_json_object(revenue, '$.mzn') > 0
   or get_json_object(revenue, '$.nad') > 0
   or get_json_object(revenue, '$.ngn') > 0
   or get_json_object(revenue, '$.nio') > 0
   or get_json_object(revenue, '$.nok') > 0
   or get_json_object(revenue, '$.npr') > 0
   or get_json_object(revenue, '$.nzd') > 0
   or get_json_object(revenue, '$.omr') > 0
   or get_json_object(revenue, '$.pab') > 0
   or get_json_object(revenue, '$.pen') > 0
   or get_json_object(revenue, '$.pgk') > 0
   or get_json_object(revenue, '$.php') > 0
   or get_json_object(revenue, '$.pkr') > 0
   or get_json_object(revenue, '$.pln') > 0
   or get_json_object(revenue, '$.pyg') > 0
   or get_json_object(revenue, '$.qar') > 0
   or get_json_object(revenue, '$.ron') > 0
   or get_json_object(revenue, '$.rsd') > 0
   or get_json_object(revenue, '$.rub') > 0
   or get_json_object(revenue, '$.rwf') > 0
   or get_json_object(revenue, '$.sar') > 0
   or get_json_object(revenue, '$.sbd') > 0
   or get_json_object(revenue, '$.scr') > 0
   or get_json_object(revenue, '$.sdg') > 0
   or get_json_object(revenue, '$.sek') > 0
   or get_json_object(revenue, '$.sgd') > 0
   or get_json_object(revenue, '$.shp') > 0
   or get_json_object(revenue, '$.sll') > 0
   or get_json_object(revenue, '$.sos') > 0
   or get_json_object(revenue, '$.srd') > 0
   or get_json_object(revenue, '$.std') > 0
   or get_json_object(revenue, '$.svc') > 0
   or get_json_object(revenue, '$.syp') > 0
   or get_json_object(revenue, '$.szl') > 0
   or get_json_object(revenue, '$.thb') > 0
   or get_json_object(revenue, '$.tjs') > 0
   or get_json_object(revenue, '$.tmt') > 0
   or get_json_object(revenue, '$.tnd') > 0
   or get_json_object(revenue, '$.top') > 0
   or get_json_object(revenue, '$.try') > 0
   or get_json_object(revenue, '$.ttd') > 0
   or get_json_object(revenue, '$.twd') > 0
   or get_json_object(revenue, '$.tzs') > 0
   or get_json_object(revenue, '$.uah') > 0
   or get_json_object(revenue, '$.ugx') > 0
   or get_json_object(revenue, '$.usd') > 0
   or get_json_object(revenue, '$.uyu') > 0
   or get_json_object(revenue, '$.uzs') > 0
   or get_json_object(revenue, '$.vef') > 0
   or get_json_object(revenue, '$.vnd') > 0
   or get_json_object(revenue, '$.vuv') > 0
   or get_json_object(revenue, '$.wst') > 0
   or get_json_object(revenue, '$.xaf') > 0
   or get_json_object(revenue, '$.xag') > 0
   or get_json_object(revenue, '$.xau') > 0
   or get_json_object(revenue, '$.xcd') > 0
   or get_json_object(revenue, '$.xdr') > 0
   or get_json_object(revenue, '$.xof') > 0
   or get_json_object(revenue, '$.xpf') > 0
   or get_json_object(revenue, '$.yer') > 0
   or get_json_object(revenue, '$.zar') > 0
   or get_json_object(revenue, '$.zmk') > 0
   or get_json_object(revenue, '$.zmw') > 0
   or get_json_object(revenue, '$.zwl') > 0
   or get_json_object(revenue, '$.AED') > 0
   or get_json_object(revenue, '$.AFN') > 0
   or get_json_object(revenue, '$.ALL') > 0
   or get_json_object(revenue, '$.AMD') > 0
   or get_json_object(revenue, '$.ANG') > 0
   or get_json_object(revenue, '$.AOA') > 0
   or get_json_object(revenue, '$.ARS') > 0
   or get_json_object(revenue, '$.AUD') > 0
   or get_json_object(revenue, '$.AWG') > 0
   or get_json_object(revenue, '$.AZN') > 0
   or get_json_object(revenue, '$.BAM') > 0
   or get_json_object(revenue, '$.BBD') > 0
   or get_json_object(revenue, '$.BDT') > 0
   or get_json_object(revenue, '$.BGN') > 0
   or get_json_object(revenue, '$.BHD') > 0
   or get_json_object(revenue, '$.BIF') > 0
   or get_json_object(revenue, '$.BMD') > 0
   or get_json_object(revenue, '$.BND') > 0
   or get_json_object(revenue, '$.BOB') > 0
   or get_json_object(revenue, '$.BRL') > 0
   or get_json_object(revenue, '$.BSD') > 0
   or get_json_object(revenue, '$.BTC') > 0
   or get_json_object(revenue, '$.BTN') > 0
   or get_json_object(revenue, '$.BWP') > 0
   or get_json_object(revenue, '$.BYR') > 0
   or get_json_object(revenue, '$.BZD') > 0
   or get_json_object(revenue, '$.CAD') > 0
   or get_json_object(revenue, '$.CDF') > 0
   or get_json_object(revenue, '$.CHF') > 0
   or get_json_object(revenue, '$.CLF') > 0
   or get_json_object(revenue, '$.CLP') > 0
   or get_json_object(revenue, '$.CNY') > 0
   or get_json_object(revenue, '$.COP') > 0
   or get_json_object(revenue, '$.CRC') > 0
   or get_json_object(revenue, '$.CUP') > 0
   or get_json_object(revenue, '$.CVE') > 0
   or get_json_object(revenue, '$.CZK') > 0
   or get_json_object(revenue, '$.DJF') > 0
   or get_json_object(revenue, '$.DKK') > 0
   or get_json_object(revenue, '$.DOP') > 0
   or get_json_object(revenue, '$.DZD') > 0
   or get_json_object(revenue, '$.EEK') > 0
   or get_json_object(revenue, '$.EGP') > 0
   or get_json_object(revenue, '$.ETB') > 0
   or get_json_object(revenue, '$.EUR') > 0
   or get_json_object(revenue, '$.FJD') > 0
   or get_json_object(revenue, '$.FKP') > 0
   or get_json_object(revenue, '$.GBP') > 0
   or get_json_object(revenue, '$.GEL') > 0
   or get_json_object(revenue, '$.GHS') > 0
   or get_json_object(revenue, '$.GIP') > 0
   or get_json_object(revenue, '$.GMD') > 0
   or get_json_object(revenue, '$.GNF') > 0
   or get_json_object(revenue, '$.GTQ') > 0
   or get_json_object(revenue, '$.GYD') > 0
   or get_json_object(revenue, '$.HKD') > 0
   or get_json_object(revenue, '$.HNL') > 0
   or get_json_object(revenue, '$.HRK') > 0
   or get_json_object(revenue, '$.HTG') > 0
   or get_json_object(revenue, '$.HUF') > 0
   or get_json_object(revenue, '$.IDR') > 0
   or get_json_object(revenue, '$.ILS') > 0
   or get_json_object(revenue, '$.INR') > 0
   or get_json_object(revenue, '$.IQD') > 0
   or get_json_object(revenue, '$.IRR') > 0
   or get_json_object(revenue, '$.ISK') > 0
   or get_json_object(revenue, '$.JEP') > 0
   or get_json_object(revenue, '$.JMD') > 0
   or get_json_object(revenue, '$.JOD') > 0
   or get_json_object(revenue, '$.JPY') > 0
   or get_json_object(revenue, '$.KES') > 0
   or get_json_object(revenue, '$.KGS') > 0
   or get_json_object(revenue, '$.KHR') > 0
   or get_json_object(revenue, '$.KMF') > 0
   or get_json_object(revenue, '$.KPW') > 0
   or get_json_object(revenue, '$.KRW') > 0
   or get_json_object(revenue, '$.KWD') > 0
   or get_json_object(revenue, '$.KYD') > 0
   or get_json_object(revenue, '$.KZT') > 0
   or get_json_object(revenue, '$.LAK') > 0
   or get_json_object(revenue, '$.LBP') > 0
   or get_json_object(revenue, '$.LKR') > 0
   or get_json_object(revenue, '$.LRD') > 0
   or get_json_object(revenue, '$.LSL') > 0
   or get_json_object(revenue, '$.LTL') > 0
   or get_json_object(revenue, '$.LVL') > 0
   or get_json_object(revenue, '$.LYD') > 0
   or get_json_object(revenue, '$.MAD') > 0
   or get_json_object(revenue, '$.MDL') > 0
   or get_json_object(revenue, '$.MGA') > 0
   or get_json_object(revenue, '$.MKD') > 0
   or get_json_object(revenue, '$.MMK') > 0
   or get_json_object(revenue, '$.MNT') > 0
   or get_json_object(revenue, '$.MOP') > 0
   or get_json_object(revenue, '$.MRO') > 0
   or get_json_object(revenue, '$.MTL') > 0
   or get_json_object(revenue, '$.MUR') > 0
   or get_json_object(revenue, '$.MVR') > 0
   or get_json_object(revenue, '$.MWK') > 0
   or get_json_object(revenue, '$.MXN') > 0
   or get_json_object(revenue, '$.MYR') > 0
   or get_json_object(revenue, '$.MZN') > 0
   or get_json_object(revenue, '$.NAD') > 0
   or get_json_object(revenue, '$.NGN') > 0
   or get_json_object(revenue, '$.NIO') > 0
   or get_json_object(revenue, '$.NOK') > 0
   or get_json_object(revenue, '$.NPR') > 0
   or get_json_object(revenue, '$.NZD') > 0
   or get_json_object(revenue, '$.OMR') > 0
   or get_json_object(revenue, '$.PAB') > 0
   or get_json_object(revenue, '$.PEN') > 0
   or get_json_object(revenue, '$.PGK') > 0
   or get_json_object(revenue, '$.PHP') > 0
   or get_json_object(revenue, '$.PKR') > 0
   or get_json_object(revenue, '$.PLN') > 0
   or get_json_object(revenue, '$.PYG') > 0
   or get_json_object(revenue, '$.QAR') > 0
   or get_json_object(revenue, '$.RON') > 0
   or get_json_object(revenue, '$.RSD') > 0
   or get_json_object(revenue, '$.RUB') > 0
   or get_json_object(revenue, '$.RWF') > 0
   or get_json_object(revenue, '$.SAR') > 0
   or get_json_object(revenue, '$.SBD') > 0
   or get_json_object(revenue, '$.SCR') > 0
   or get_json_object(revenue, '$.SDG') > 0
   or get_json_object(revenue, '$.SEK') > 0
   or get_json_object(revenue, '$.SGD') > 0
   or get_json_object(revenue, '$.SHP') > 0
   or get_json_object(revenue, '$.SLL') > 0
   or get_json_object(revenue, '$.SOS') > 0
   or get_json_object(revenue, '$.SRD') > 0
   or get_json_object(revenue, '$.STD') > 0
   or get_json_object(revenue, '$.SVC') > 0
   or get_json_object(revenue, '$.SYP') > 0
   or get_json_object(revenue, '$.SZL') > 0
   or get_json_object(revenue, '$.THB') > 0
   or get_json_object(revenue, '$.TJS') > 0
   or get_json_object(revenue, '$.TMT') > 0
   or get_json_object(revenue, '$.TND') > 0
   or get_json_object(revenue, '$.TOP') > 0
   or get_json_object(revenue, '$.TRY') > 0
   or get_json_object(revenue, '$.TTD') > 0
   or get_json_object(revenue, '$.TWD') > 0
   or get_json_object(revenue, '$.TZS') > 0
   or get_json_object(revenue, '$.UAH') > 0
   or get_json_object(revenue, '$.UGX') > 0
   or get_json_object(revenue, '$.USD') > 0
   or get_json_object(revenue, '$.UYU') > 0
   or get_json_object(revenue, '$.UZS') > 0
   or get_json_object(revenue, '$.VEF') > 0
   or get_json_object(revenue, '$.VND') > 0
   or get_json_object(revenue, '$.VUV') > 0
   or get_json_object(revenue, '$.WST') > 0
   or get_json_object(revenue, '$.XAF') > 0
   or get_json_object(revenue, '$.XAG') > 0
   or get_json_object(revenue, '$.XAU') > 0
   or get_json_object(revenue, '$.XCD') > 0
   or get_json_object(revenue, '$.XDR') > 0
   or get_json_object(revenue, '$.XOF') > 0
   or get_json_object(revenue, '$.XPF') > 0
   or get_json_object(revenue, '$.YER') > 0
   or get_json_object(revenue, '$.ZAR') > 0
   or get_json_object(revenue, '$.ZMK') > 0
   or get_json_object(revenue, '$.ZMW') > 0
   or get_json_object(revenue, '$.ZWL') > 0;