#! /bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @file    :extract_device.sh
# @author  :liushuai
# @revision:2017-01-18 17:01
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=$(date +%Y%m%d -d "-1 day $ScheduleTime")
year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}


INPUT_PATH="${GENDER_MERGE_INSTALL}/${year}/${month}/${day}/"
OUTPUT_PATH="${GENDER_CALC_DEVICE}/${year}/${month}/${day}/"
OUTPUT_PATH_V2="${GENDER_CALC_DEVICE}_v2/${year}/${month}/${day}/"
FILEDICT="${GENDER_CALC_PACKAGE_DICT}/${year}/${month}/${day}/part-r-00000"

hadoop fs -rm -r ${OUTPUT_PATH}
REDUCE_NUM=$(calculate_reduce_num ${INPUT_PATH})
hadoop jar ../${JAR} mobvista.dmp.datasource.gender.CalcDeviceGenderMR \
    -Dmapreduce.job.reduces=${REDUCE_NUM} \
    -DoutPath=${OUTPUT_PATH} -DoutPath_v2=${OUTPUT_PATH_V2} "${INPUT_PATH}" "${OUTPUT_PATH}" "${FILEDICT}"

if [ $? -ne 0 ];then
   exit 255
fi

mount_partition "dm_device_gender" "year='$year', month='$month', day='$day'" "$OUTPUT_PATH"

mount_partition "dm_device_gender_v2" "year='$year', month='$month', day='$day'" "$OUTPUT_PATH_V2"
