#! /bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @file    :extract_device.sh
# @author  :liushuai
# @revision:2017-01-18 16:12
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=$(date +%Y%m%d -d "-1 day $ScheduleTime")
dt=$(date +'%Y-%m-%d' -d "-1 day $ScheduleTime")
date_path=$(date +'%Y/%m/%d' -d "-1 day $ScheduleTime")


INSTALL_3S_INPUT="${DM_INSTALL_LIST}/$date_path/3s"
ADN_INSTALL_INPUT="${DM_INSTALL_LIST}/$date_path/adn_install"
ADN_REQUEST_INPUT="${DM_INSTALL_LIST}/$date_path/adn_request_sdk"
DSP_REQUEST_INPUT="${DM_INSTALL_LIST}/$date_path/dsp_req"
GA_INSTALL_INPUT=$(get_recently_dir "${DM_INSTALL_LIST}" "${LOG_TIME}" "ga")
OTHER_INPUT=$(get_recently_dir "$DM_INSTALL_LIST" "$LOG_TIME" "other")
OUTPUT_PATH="${GENDER_EXTRACT_DEVICE_PATH}/$date_path/"


check_await $INSTALL_3S_INPUT/_SUCCESS
check_await $ADN_INSTALL_INPUT/_SUCCESS
check_await $ADN_REQUEST_INPUT/_SUCCESS
check_await $DSP_REQUEST_INPUT/_SUCCESS

REDUCE_NUM=$(calculate_reduce_num "${ADN_INSTALL_INPUT};${ADN_REQUEST_INPUT};${DSP_REQUEST_INPUT};${GA_INSTALL_INPUT};${OTHER_INPUT};${INSTALL_3S_INPUT}")

hadoop fs -rmr ${OUTPUT_PATH}

hadoop jar ../${JAR} mobvista.dmp.datasource.gender.ExtractDeviceMRV2 \
    -Dmapreduce.job.reduces=${REDUCE_NUM:-100} \
    -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
    -Dtime="$dt" \
    -Dmapreduce.input.fileinputformat.inputdir="${ADN_INSTALL_INPUT},${ADN_REQUEST_INPUT},${DSP_REQUEST_INPUT},${GA_INSTALL_INPUT},${OTHER_INPUT}" \
    ${INSTALL_3S_INPUT} ${OUTPUT_PATH} || exit 1

if [ $? -ne 0 ]; then
    exit 255
fi

echo "[extract device End!]"
