#!/bin/sh

# # # # # # # # # # # # # # # # # # # # # #
# @author : wangjf
# @date : 2020-05-14 17:27:31
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
date_path=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")

ODS_USER_INFO_PATH="${ODS_DMP_USER_INFO_DAILY}/$LOG_TIME"

check_await "${ODS_USER_INFO_PATH}/_SUCCESS"

host="ip-172-31-20-35.ec2.internal"
cluster="cluster_1st"
database="dwh"
table="etl_iqiyi_daily"

spark-submit --class mobvista.dmp.datasource.iqiyi.IQiYiEtl2CK \
     --name "IQiYiEtl2CK.${LOG_TIME}" \
     --conf spark.sql.shuffle.partitions=1000 \
     --conf spark.default.parallelism=1000 \
     --conf spark.kryoserializer.buffer.max=256m \
     --conf spark.driver.extraJavaOptions="-XX:+UseG1GC" \
     --conf spark.executor.extraJavaOptions="-XX:+UseG1GC" \
     --conf hive.exec.orc.default.stripe.size=268435456 \
     --conf spark.sql.files.maxPartitionBytes=268435456 \
     --files ${HIVE_SITE_PATH} \
     --master yarn --deploy-mode cluster --executor-memory 4g --driver-memory 4g  --executor-cores 2  --num-executors 50 \
     ../${JAR} -date ${LOG_TIME} -host ${host} -cluster ${cluster} -database ${database} -table ${table}

if [[ $? -ne 0 ]];then
  exit 255
fi