#!/bin/bash

source ../dmp_env.sh

part=$1

today=${ScheduleTime}

date_time=$(date +"%Y-%m-%d.%H" -d "-1 hour $today")

date_path=$(date +%Y/%m/%d/%H -d "-1 hour $today")

part_num=$(hadoop fs -ls s3://mob-emr-test/dataplatform/rtdmp_pre/${date_path}/ | wc -l)
if [[ ${part_num} -le 50 && ${part} -ne 0 ]]; then
  echo "This Dir No Data !!!"
  exit 0
else

  INPUT="s3://mob-emr-test/dataplatform/rtdmp_pre/${date_path}/part-000${part}*"

  OUTPUT="s3://mob-emr-test/dataplatform/rtdmp_deal/${date_path}/${part}"

  sleep 10

  spark-submit --class mobvista.dmp.datasource.rtdmp.RTDmpMainDealV2 \
    --name "RTDmpMainDealV2.${date_time}.${part}" \
    --conf spark.sql.shuffle.partitions=2000 \
    --conf spark.default.parallelism=2000 \
    --conf spark.kryoserializer.buffer.max=256m \
    --master yarn --deploy-mode cluster --executor-memory 10g --driver-memory 4g --executor-cores 5 --num-executors 20 \
    ../${JAR} -time "${date_time}" -input ${INPUT} -output ${OUTPUT} -coalesce 100 -partition 2000

  if [[ $? -ne 0 ]]; then
    exit 255
  fi
fi
