#!/bin/bash

source ../dmp_env.sh

today=${ScheduleTime}

date_time=$(date +"%Y-%m-%d.%H" -d "-1 hour $today")

date_path=$(date +%Y/%m/%d/%H -d "-1 hour $today")

OUTPUT="s3://mob-emr-test/dataplatform/rtdmp_pre/${date_path}"

spark-submit --class mobvista.dmp.datasource.rtdmp.RTDmpMainPre \
    --name "RTDmpMainPre.${date_time}" \
    --conf spark.sql.shuffle.partitions=1000 \
    --conf spark.default.parallelism=1000 \
    --conf spark.kryoserializer.buffer.max=256m \
    --conf spark.sql.adaptive.enabled=true \
    --conf spark.sql.adaptive.advisoryPartitionSizeInBytes=134217728 \
    --master yarn --deploy-mode cluster --executor-memory 12g --driver-memory 8g  --executor-cores 5 --num-executors 20 \
    ../${JAR} -time "${date_time}" -data_utime "${date_time}" -output ${OUTPUT} -coalesce 100

if [[ $? -ne 0 ]]; then
    exit 255
fi