drop table dm_device_tag_v2;
create external table dm_device_tag_v2 (
  device_id string comment 'device id',
  device_type string comment 'gaid or idfa',
  platform string comment 'platform',
  feat_id array<string> comment '标签ID',
  update_date string comment '更新时间，yyyy-MM-dd'
) PARTITION BY (
  dt string comment '分区字段，yyyyMMdd',
  source string comment '数据来源, manual、dc、toutiao、external',
  business string comment '业务或第三方DMP名称')
ROW FORMAT SERDE 'org.apache.hadoop.hive.ql.io.orc.OrcSerde'
STORED AS INPUTFORMAT
  'org.apache.hadoop.hive.ql.io.orc.OrcInputFormat'
OUTPUTFORMAT
  'org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat'
location 's3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/dm_device_tag_v2';


CREATE EXTERNAL TABLE `dm_new_tag`(
  `first_tag` string,
  `second_tag` string,
  `first_id` string,
  `second_id` string)
ROW FORMAT DELIMITED FIELDS TERMINATED BY ','
location 's3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/dm_new_tag';

CREATE EXTERNAL TABLE `dm_old2new_tag`(
  `tag_type` string,
  `first_tag` string,
  `second_tag` string,
  `comment_cn` string,
  `comment_en` string,
  `tag_id` string,
  `new_first_tag` string,
  `new_second_tag` string,
  `new_first_id` string,
  `new_second_id` string)
ROW FORMAT DELIMITED FIELDS TERMINATED BY ','
location 's3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/dm_old2new_tag';