USE dwh;
DROP TABLE IF EXISTS `dm_interest_tag`;

CREATE EXTERNAL TABLE `dm_interest_tag`(
  device_id string,
  device_type string,
  platform string,
  tags string
)PARTITIONED BY (
  year string,
  month string,
  day string,
  business string)
ROW FORMAT SERDE 'org.apache.hadoop.hive.ql.io.orc.OrcSerde'
STORED AS INPUTFORMAT
  'org.apache.hadoop.hive.ql.io.orc.OrcInputFormat'
OUTPUTFORMAT
  'org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat'
location 's3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/dm_interest_tag';

ALTER TABLE dm_interest_tag RENAME TO dm_interest_tag_old;

CREATE EXTERNAL TABLE `dm_interest_tag_orc`(
  device_id string,
  device_type string,
  platform string,
  tags string,
  update_date string comment "用于过滤活跃设备",
  ext_data string comment "用于下游进行 Filter 操作，JSON格式"
)PARTITIONED BY (
  dt string)
ROW FORMAT SERDE 'org.apache.hadoop.hive.ql.io.orc.OrcSerde'
STORED AS INPUTFORMAT
  'org.apache.hadoop.hive.ql.io.orc.OrcInputFormat'
OUTPUTFORMAT
  'org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat'
location 's3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/dm_interest_tag_orc';