USE dwh;
DROP TABLE IF EXISTS dwh.etl_adn_request_sdk_daily;
CREATE EXTERNAL TABLE dwh.etl_adn_request_sdk_daily
(
    device_id    string,
    device_type  string,
    platform     string,
    app_id       string,
    package_name string,
    update_date  string,
    model        string,
    brand        string,
    os_version   string,
    country      string,
    strategy     string,
    region       string,
    dev_tag      int
) PARTITIONED BY (
    dt string
    ) ROW FORMAT SERDE 'org.apache.hadoop.hive.ql.io.orc.OrcSerde'
    STORED AS INPUTFORMAT
        'org.apache.hadoop.hive.ql.io.orc.OrcInputFormat'
        OUTPUTFORMAT
            'org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat'
    LOCATION 's3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/etl_adn_request_sdk_daily';

USE dwh;
DROP TABLE IF EXISTS dwh.etl_adn_request_sdk_unmatch;
CREATE EXTERNAL TABLE dwh.etl_adn_request_sdk_unmatch
(
    device_id    string,
    device_type  string,
    platform     string,
    app_id       string,
    package_name string,
    update_date  string,
    model        string,
    brand        string,
    os_version   string,
    country      string,
    strategy     string,
    region       string,
    dev_tag      int
) PARTITIONED BY (
    dt string
    ) ROW FORMAT SERDE 'org.apache.hadoop.hive.ql.io.orc.OrcSerde'
    STORED AS INPUTFORMAT
        'org.apache.hadoop.hive.ql.io.orc.OrcInputFormat'
        OUTPUTFORMAT
            'org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat'
    LOCATION 's3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/etl_adn_request_sdk_unmatch';