drop table ods_dmp_user_info;
CREATE EXTERNAL TABLE ods_dmp_user_info(
   device_id string comment 'gaid or idfa',
   device_type string comment 'gaid or idfa',
   platform string comment 'android or ios',
   country string comment '',
   age string comment 'age range, example 0-17',
   gender string comment 'f or m or o',
   tags string comment 'interest tags',
   first_req_day string comment 'first request day [yyyy-mm-dd]',
   last_req_day string comment 'last request day [yyyy-mm-dd]'
)
PARTITIONED BY (
  dt string,
  business string
)
STORED AS orc
LOCATION 's3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/ods_dmp_user_info';
-- TBLPROPERTIES (
--   'orc.bloom.filter.columns'='device_id,device_type,country,age,gender,tags'
-- );