package mobvista.dmp.datasource.apptag.mapreduce;

import mobvista.dmp.datasource.ga.mapreduce.vo.TextPair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

import java.io.IOException;

/**
 * author: houying
 * date  : 16-11-7
 * desc  :
 */
public class MergeIosAppInfo extends Configured implements Tool {

    public static class MergeIosMapper extends Mapper<LongWritable, Text, TextPair, Text> {
        @Override
        protected void map(LongWritable k, Text value, Context context) throws IOException, InterruptedException {
            String filePath = context.getConfiguration().get("map.input.file");
            String line = value.toString();
            int index = line.indexOf("\t");
            if (index != -1) {
                String key = line.substring(0, index);
                String order = "0";
                if (filePath.contains("/dwh/dim_app_info_ios")) {
                    order = "1";
                }
                context.write(new TextPair(key, order), value);
            }
        }
    }

    public static class MergeIosReducer extends Reducer<TextPair, Text, NullWritable, Text> {
        private Text outKey = new Text();
        private int exceptionCount = 0;
        @Override
        protected void cleanup(Context context) throws IOException, InterruptedException {
            System.out.println("exception count is " + exceptionCount);
        }

        @Override
        protected void reduce(TextPair key, Iterable<Text> values, Context context) throws IOException, InterruptedException {
            for (Text value: values) {
                context.write(NullWritable.get(), value);
                break;
            }
        }
    }

    @Override
    public int run(String[] args) throws Exception {
        Configuration conf = getConf();
        Job job = Job.getInstance(conf, "merge ios app info");
        job.setJarByClass(MergeIosAppInfo.class);

        FileInputFormat.addInputPath(job, new Path(args[0]));
        FileInputFormat.addInputPath(job, new Path(args[1]));
        Path outputPath = new Path(args[2]);
        FileSystem fileSystem = outputPath.getFileSystem(conf);
        if (fileSystem.exists(outputPath)) {
            fileSystem.delete(outputPath, true);
        }
        FileOutputFormat.setOutputPath(job, outputPath);
        FileOutputFormat.setCompressOutput(job, false);

        job.setMapperClass(MergeIosMapper.class);
        job.setMapOutputKeyClass(TextPair.class);
        job.setMapOutputValueClass(Text.class);
        job.setGroupingComparatorClass(TextPair.FirstComparator.class);
        job.setPartitionerClass(TextPair.FirstPartitioner.class);

        job.setReducerClass(MergeIosReducer.class);
        job.setNumReduceTasks(1);
        job.setOutputFormatClass(TextOutputFormat.class);
        job.setOutputKeyClass(NullWritable.class);
        job.setOutputValueClass(Text.class);
        return job.waitForCompletion(true) ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run(new Configuration(), new MergeIosAppInfo(), args));
    }
}
