package mobvista.dmp.datasource.rtdmp;

import com.alibaba.fastjson.JSONObject;
import mobvista.dmp.common.Constants;
import mobvista.dmp.util.DateUtil;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Date;

/**
 * @package: mobvista.dmp.datasource.rtdmp
 * @author: wangjf
 * @date: 2020/8/20
 * @time: 1:43 下午
 * @email: jinfeng.wang@mobvista.com
 * @phone: 152-1062-7698
 */
public class ServerMain {

    public static final Logger logger = LoggerFactory.getLogger(ServerMain.class);

    private static final String BASE_URL = "http://ip-172-31-29-117:8688/";

    public static void main(String[] args) throws URISyntaxException {

        String update_time_start;
        String update_time_end;
        if (args.length >= 2) {
            update_time_start = args[0];
            update_time_end = args[1];
        } else {
            Calendar cal = Calendar.getInstance();
            Date date = new Date();
            cal.setTime(date);
            cal.add(Calendar.DATE, -24);
            update_time_start = DateUtil.format(cal.getTime(), "yyyy-MM-dd HH") + ":00:00";
            cal.setTime(date);
            cal.add(Calendar.DATE, -1);
            update_time_end = DateUtil.format(cal.getTime(), "yyyy-MM-dd HH") + ":59:59";
        }

        JSONObject requestBody = new JSONObject();
        requestBody.put("update_time_start", update_time_start);
        requestBody.put("update_time_end", update_time_end);

        CloseableHttpClient client = HttpClients.createDefault();

        final String serverUrl = BASE_URL + "dmp/fetch";
        URIBuilder uri = new URIBuilder();
        try {
            uri = new URIBuilder(serverUrl).addParameter("flag", String.valueOf(1));
        } catch (URISyntaxException e) {
            e.printStackTrace();
        }

        final HttpPost httpPost = new HttpPost(uri.build());

        RequestConfig requestConfig = RequestConfig.custom()
                .setConnectTimeout(1000).setConnectionRequestTimeout(1000)
                .setSocketTimeout(1000).build();

        httpPost.setHeader("Auth-System", "dmp");
        httpPost.setHeader("Content-Type", "text/plain");

        CloseableHttpResponse response;
        try {
            httpPost.setConfig(requestConfig);
            httpPost.setEntity(new StringEntity(requestBody.toJSONString()));
            response = client.execute(httpPost);
            BufferedReader rd = new BufferedReader(
                    new InputStreamReader(response.getEntity().getContent()));
            StringBuilder result = new StringBuilder();
            String line;
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
            JSONObject jsonObject = Constants.String2JSONObject(result.toString());
            if (jsonObject.getInteger("code") == 200 && jsonObject.containsKey("data")) {
                logger.info("Audience data fetch success!");
            }
        } catch (IOException e) {
            logger.info(e.getMessage());
        } finally {
            httpPost.abort();
        }
        logger.info("OK!");
        System.exit(0);
    }
}
