package mobvista.dmp.datasource.rtdmp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import mobvista.dmp.common.Constants;
import mobvista.dmp.util.DateUtil;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple4;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @package: mobvista.dmp.datasource.rtdmp
 * @author: wangjf
 * @date: 2020/7/20
 * @time: 4:44 下午
 * @email: jinfeng.wang@mobvista.com
 * @phone: 152-1062-7698
 */
public class ServerUtil {

    public static final Logger logger = LoggerFactory.getLogger(ServerUtil.class);

    //  private final static String BASE_URL = PropertyUtil.getProperty("config.properties", "rtdmp.url");
    private final static String BASE_URL = "http://ip-172-31-29-117:8688/";
    //  private final static String BASE_URL = "http://107.21.162.31:8688/";

    //  Map<id,<paths,data_update_method,audience_type,audience_rules>>
    public static Map<Integer, Tuple4<JSONArray, Integer, Integer, JSONObject>> request(
            String update_time_start, String update_time_end, Long audience_data_utime_start, Long audience_data_utime_end,
            int audienceType, int minAudienceDataStatus, int maxAudienceDataStatus) {

        logger.info("update_time_start -->>" + update_time_start + ",update_time_end -->> " + update_time_end + ",audience_data_utime_start -->> " +
                audience_data_utime_start + ",audience_data_utime_end -->> " + audience_data_utime_end + ",audience_type -->> " + audienceType);

        CloseableHttpClient client = HttpClients.createDefault();
        List<BasicNameValuePair> formparams = new ArrayList<>();

        String serverUrl = BASE_URL + "rtdmp/query";
        URIBuilder uri = new URIBuilder();
        try {
            uri = new URIBuilder(serverUrl)
                    .addParameter("update_time_start", update_time_start)
                    .addParameter("update_time_end", update_time_end)
                    .addParameter("audience_data_utime_start", String.valueOf(audience_data_utime_start))
                    .addParameter("audience_data_utime_end", String.valueOf(audience_data_utime_end))
                    .addParameter("audience_type", String.valueOf(audienceType))
                    .addParameter("min_audience_data_status", String.valueOf(minAudienceDataStatus))
                    .addParameter("max_audience_data_status", String.valueOf(maxAudienceDataStatus));
        } catch (URISyntaxException e) {
            e.printStackTrace();
        }
        RequestConfig requestConfig = RequestConfig.custom()
                .setConnectTimeout(5000).setConnectionRequestTimeout(5000)
                .setSocketTimeout(5000).build();

        HttpGet httpGet = new HttpGet();
        try {
            logger.info("uri -->> " + uri.build());
            httpGet = new HttpGet(uri.build());
        } catch (URISyntaxException e) {
            e.printStackTrace();
        }

        httpGet.setHeader("Auth-System", "dmp");
        httpGet.setHeader("Content-Type", "text/plain");

        JSONArray jsonArray;
        CloseableHttpResponse response;

        Map<Integer, Tuple4<JSONArray, Integer, Integer, JSONObject>> map = new HashMap<>();
        JSONObject jsonObject;
        try {
            response = client.execute(httpGet);
            BufferedReader rd = new BufferedReader(
                    new InputStreamReader(response.getEntity().getContent()));
            StringBuilder result = new StringBuilder();
            String line;
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }

            jsonObject = Constants.String2JSONObject(result.toString());
        } catch (IOException e) {
            jsonObject = new JSONObject();
            logger.info(e.getMessage());
        } finally {
            httpGet.abort();
        }

        for (Map.Entry<String, Object> entry : jsonObject.entrySet()) {
            JSONObject valueJson = Constants.String2JSONObject(entry.getValue().toString());
            if (valueJson.containsKey("is_sync_dmpserver") && valueJson.getInteger("is_sync_dmpserver") == 1) {
                map.put(Integer.parseInt(entry.getKey()), new Tuple4<>(valueJson.getJSONArray("paths"), valueJson.getInteger("data_update_method"),
                        valueJson.getInteger("audience_type"), valueJson.getJSONObject("audience_rules")));
            }
        }
        return map;
    }

    public static JSONArray history(int audienceId) throws URISyntaxException {

        CloseableHttpClient client = HttpClients.createDefault();
        List<BasicNameValuePair> formparams = new ArrayList<>();

        final String serverUrl = BASE_URL + "rtdmp/audience/history";
        URIBuilder uri = new URIBuilder();
        try {
            uri = new URIBuilder(serverUrl).addParameter("audience_id", String.valueOf(audienceId));
        } catch (URISyntaxException e) {
            e.printStackTrace();
        }

        RequestConfig requestConfig = RequestConfig.custom()
                .setConnectTimeout(1000).setConnectionRequestTimeout(1000)
                .setSocketTimeout(1000).build();

        final HttpGet httpGet = new HttpGet(uri.build());

        httpGet.setHeader("Auth-System", "dmp");
        httpGet.setHeader("Content-Type", "text/plain");

        JSONArray jsonArray = new JSONArray();
        CloseableHttpResponse response;
        try {
            response = client.execute(httpGet);
            BufferedReader rd = new BufferedReader(
                    new InputStreamReader(response.getEntity().getContent()));
            StringBuilder result = new StringBuilder();
            String line;
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
            JSONObject jsonObject = Constants.String2JSONObject(result.toString());
            if (jsonObject.getInteger("code") == 200 && jsonObject.containsKey("data")) {
                jsonArray = jsonObject.getJSONArray("data");
            }
        } catch (IOException e) {
            try {
                response = client.execute(httpGet);
                BufferedReader rd = new BufferedReader(
                        new InputStreamReader(response.getEntity().getContent()));
                StringBuilder result = new StringBuilder();
                String line;
                while ((line = rd.readLine()) != null) {
                    result.append(line);
                }
                JSONObject jsonObject = Constants.String2JSONObject(result.toString());
                if (jsonObject.getInteger("code") == 200 && jsonObject.containsKey("data")) {
                    jsonArray = jsonObject.getJSONArray("data");
                }
            } catch (IOException ex) {
                jsonArray = new JSONArray();
            }
        } finally {
            httpGet.abort();
        }

        for (int i = 0; i < jsonArray.size(); i++) {
            jsonArray.getJSONObject(i).remove("audience_id");
            jsonArray.getJSONObject(i).put("update_time", DateUtil.format(jsonArray.getJSONObject(i).getString("update_time"), "yyyy-MM-dd HH"));
        }
        return jsonArray;
    }

    public static JSONObject upload(JSONArray requestBody) {

        logger.info("requestBody -->> " + requestBody);
        CloseableHttpClient client = HttpClients.createDefault();

        RequestConfig requestConfig = RequestConfig.custom()
                .setConnectTimeout(5000).setConnectionRequestTimeout(5000)
                .setSocketTimeout(5000).build();

        final String serverUrl = BASE_URL + "rtdmp/upload";
        HttpPost post = new HttpPost(serverUrl);
        JSONObject jsonObject = new JSONObject();
        HttpResponse response;
        try {
            post.setConfig(requestConfig);
            post.setEntity(new StringEntity(requestBody.toJSONString()));
            response = client.execute(post);
            BufferedReader rd = new BufferedReader(
                    new InputStreamReader(response.getEntity().getContent()));
            StringBuilder result = new StringBuilder();
            String line;
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
            jsonObject = JSON.parseObject(result.toString());
        } catch (IOException e) {
            logger.info("IOException -->> " + e.getMessage());
        } finally {
            post.abort();
        }
        logger.info("jsonObject -->> " + jsonObject.toJSONString());
        return jsonObject;
    }

    public static JSONObject update(JSONArray requestBody) {

        logger.info("requestBody -->> " + requestBody);
        CloseableHttpClient client = HttpClients.createDefault();

        RequestConfig requestConfig = RequestConfig.custom()
                .setConnectTimeout(5000).setConnectionRequestTimeout(5000)
                .setSocketTimeout(5000).build();

        final String serverUrl = BASE_URL + "rtdmp/update";
        HttpPost post = new HttpPost(serverUrl);
        JSONObject jsonObject = new JSONObject();
        HttpResponse response;
        try {
            post.setConfig(requestConfig);
            post.setEntity(new StringEntity(requestBody.toJSONString()));
            response = client.execute(post);
            BufferedReader rd = new BufferedReader(
                    new InputStreamReader(response.getEntity().getContent()));
            StringBuilder result = new StringBuilder();
            String line;
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
            jsonObject = JSON.parseObject(result.toString());
        } catch (IOException e) {
            try {
                post.setConfig(requestConfig);
                post.setEntity(new StringEntity(requestBody.toJSONString()));
                response = client.execute(post);
                BufferedReader rd = new BufferedReader(
                        new InputStreamReader(response.getEntity().getContent()));
                StringBuilder result = new StringBuilder();
                String line;
                while ((line = rd.readLine()) != null) {
                    result.append(line);
                }
                jsonObject = JSON.parseObject(result.toString());
            } catch (IOException ex) {
                logger.info("IOException -->> " + ex.getMessage());
            }
        } finally {
            post.abort();
        }
        logger.info("jsonObject -->> " + jsonObject.toJSONString());
        return jsonObject;
    }

    public static int query(String audienceName) throws URISyntaxException {

        logger.info("audienceName -->> " + audienceName);
        CloseableHttpClient client = HttpClients.createDefault();
        List<BasicNameValuePair> formparams = new ArrayList<>();

        final String serverUrl = BASE_URL + "rtdmp/queryByName";
        URIBuilder uri = new URIBuilder();
        try {
            uri = new URIBuilder(serverUrl).addParameter("audience_name", audienceName);
        } catch (URISyntaxException e) {
            e.printStackTrace();
        }

        RequestConfig requestConfig = RequestConfig.custom()
                .setConnectTimeout(1000).setConnectionRequestTimeout(1000)
                .setSocketTimeout(1000).build();

        final HttpGet httpGet = new HttpGet(uri.build());

        httpGet.setHeader("Auth-System", "dmp");
        httpGet.setHeader("Content-Type", "text/plain");

        int audienceId = 0;
        CloseableHttpResponse response;
        try {
            response = client.execute(httpGet);
            BufferedReader rd = new BufferedReader(
                    new InputStreamReader(response.getEntity().getContent()));
            StringBuilder result = new StringBuilder();
            String line;
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
            JSONObject jsonObject = Constants.String2JSONObject(result.toString());
            if (!jsonObject.isEmpty() && jsonObject.containsKey("id")) {
                audienceId = jsonObject.getIntValue("id");
            }
        } catch (IOException e) {
            logger.info(e.getMessage());
        } finally {
            httpGet.abort();
        }
        return audienceId;
    }
}
