package mobvista.dmp.datasource.toutiao.dmp;

import com.google.protobuf.InvalidProtocolBufferException;

import java.io.*;
import java.util.Base64;

public class GetDeviceidFromProtocolBuffer {
    public static void main(String[] args) {
        String inputFileName = args[0];
        String outputFileName = args[1];
        String line = "";
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(outputFileName));
            BufferedReader in = new BufferedReader(new FileReader(inputFileName));
            line = in.readLine();
            while (line != null) {
                String device_id = getOriginalDataFromProtocolBufferBase64String(line);
                out.write(device_id + "\n");
                line = in.readLine();
            }
            in.close();
            out.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getOriginalDataFromProtocolBufferBase64String(String line){
        DmpDataProto.DmpData dmpData = null;
        try {
            Base64.Decoder decoder = Base64.getDecoder();
            byte[] decode = decoder.decode(line);
            dmpData = DmpDataProto.DmpData.parseFrom(decode);
        } catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
        }
        return dmpData.getIdList(0).getId();
    }
}

