package mobvista.dmp.format;

import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.CombineFileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.CombineFileRecordReader;
import org.apache.hadoop.mapreduce.lib.input.CombineFileRecordReaderWrapper;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.apache.orc.mapreduce.OrcInputFormat;

import java.io.IOException;

public class CombineOrcInputFormat<K, V> extends CombineFileInputFormat<K, V> {

    public CombineOrcInputFormat () {

    }

    public RecordReader createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException {
        return new CombineFileRecordReader(
                (CombineFileSplit)split, context, OrcRecordReaderWrapper.class);
    }

    /**
     * @see CombineFileRecordReader
     * @see CombineFileInputFormat
     * @see OrcInputFormat
     */
    private static class OrcRecordReaderWrapper<K, V>
            extends CombineFileRecordReaderWrapper<K, V> {
        // this constructor signature is required by CombineFileRecordReader
        public OrcRecordReaderWrapper(CombineFileSplit split,
                                       TaskAttemptContext context, Integer idx)
                throws IOException, InterruptedException {
            super(new OrcInputFormat(), split, context, idx);
        }
    }
}
