package mobvista.dmp.format;

import org.apache.hadoop.io.Text;

public class TextMultipleOutputFormat extends MultipleOutputFormat<Text, Text> {
	protected String generateFileNameForKeyValue(Text key, Text value,
			String name) {
		String temp = key.toString();
		int pos = temp.indexOf(",");
		if (pos != -1) {
			temp = temp.substring(0, pos);
		}
		return temp + "/" + name;
	}

	protected Text generateActualKey(Text key, Text value) {
		String temp = key.toString();
		int pos = temp.indexOf(",");
		if (pos == -1)
			return key;
		String outKey = temp.substring(pos + 1).trim();
		if ("".equals(outKey)) {
			return null;
		}
		return new Text(temp.substring(pos + 1));
	}
}