package mobvista.prd.datasource.eggplants;

import com.google.common.collect.Lists;
import org.apache.poi.hssf.usermodel.*;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;

/**
 * Created by Administrator on 2017/4/30 0030.
 */
public class EggplantsCountTable {
    public static void main(String[] args) throws IOException {
        List<String> interestList = readInterest("./eggplants");
        FileOutputStream fos = new FileOutputStream("./茄子分国家分app.xls");
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet s = wb.createSheet();
        int columnHead = 0;
        int rowLine = 0;
        HSSFRow rowOne = s.createRow(0);
        for (String column : interestList) {
            HSSFRow row = s.createRow(rowLine);
            String[] fields = column.split("\t",-1);
            columnHead = 0;
            for (String line : fields) {
                HSSFCell cell = row.createCell(columnHead, 0);
                HSSFRichTextString hts = new HSSFRichTextString(line);
                cell.setCellValue(hts);
                columnHead++;
            }
            rowLine++;
        }
        wb.write(fos);
        fos.flush();
        fos.close();
    }
    public static List readInterest (String path) throws IOException {
        List interestList = Lists.newArrayList();

        FileReader fr = new FileReader(path);
        BufferedReader br = new BufferedReader(fr);
        String s = br.readLine();
        while (s != null) {
            interestList.add(s);
            s = br.readLine();//再读下一行
        }
        return interestList;
    }
}
