package mobvista.prd.datasource.table;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.poi.hssf.usermodel.*;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2017/3/13 0013.
 */
public class CreateCountryGenderAgeTable {
    public static void main(String[] args) throws IOException {
        Map<String, List<String>> dspCountry = Maps.newLinkedHashMap();
        Map<String, List<String>> mCountry = Maps.newLinkedHashMap();
        dspCountry = readCountry("./dspCountryCount.txt", "dsp");
        mCountry = readCountry("./mCountryCount.txt", "Mintegral");
        //添加表头
        FileOutputStream fos = new FileOutputStream("./Top30国家的性别年龄.xls");
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet s = wb.createSheet();
        List<String> head = Lists.newArrayList();//表头
        head.add("Data source");
        head.add("country");
        head.add("DMP DAU");
        head.add("Male");
        head.add("Female");
        head.add("Gender unknown");
        head.add("Age 0-18");
        head.add("Age 19-25");
        head.add("Age 26-45");
        head.add("Age 46-60");
        head.add("Age above 60");
        head.add("Age unknown");
        int columnHead = 0;
        HSSFRow rowOne = s.createRow(0);
        for (String column : head) {
            HSSFCell cell = rowOne.createCell(columnHead, 0);
            HSSFRichTextString hts = new HSSFRichTextString(column);
            cell.setCellValue(hts);
            columnHead++;
        }
        int rowLine = 1;
        for (Map.Entry<String, List<String>> countryCount : dspCountry.entrySet()) {
            HSSFRow row = s.createRow(rowLine);  //行
            int columnNum = 0;
            HSSFCell cell = row.createCell(columnNum, 0);
            String source = countryCount.getKey().split(":",-1)[0];
            String country = countryCount.getKey().split(":",-1)[1];
            HSSFRichTextString hts = new HSSFRichTextString(source);
            cell.setCellValue(hts);
            columnNum++;
            cell = row.createCell(columnNum, 0);
            hts = new HSSFRichTextString(country);
            cell.setCellValue(hts);
            columnNum++;
            int notWrite = 0;
            for (String column : countryCount.getValue()) {
                if (notWrite == 0) {
                    notWrite++;
                    continue;
                }
                cell = row.createCell(columnNum, 0);
                hts = new HSSFRichTextString(column);
                cell.setCellValue(hts);
                columnNum++;
            }

            rowLine++;
        }
        for (Map.Entry<String, List<String>> countryCount : mCountry.entrySet()) {
            HSSFRow row = s.createRow(rowLine);  //行
            int columnNum = 0;
            HSSFCell cell = row.createCell(columnNum, 0);
            String source = countryCount.getKey().split(":",-1)[0];
            String country = countryCount.getKey().split(":",-1)[1];
            HSSFRichTextString hts = new HSSFRichTextString(source);
            cell.setCellValue(hts);
            columnNum++;
            cell = row.createCell(columnNum, 0);
            hts = new HSSFRichTextString(country);
            cell.setCellValue(hts);
            columnNum++;
            int notWrite = 0;
            for (String column : countryCount.getValue()) {
                if (notWrite == 0) {
                    notWrite++;
                    continue;
                }
                cell = row.createCell(columnNum, 0);
                hts = new HSSFRichTextString(column);
                cell.setCellValue(hts);
                columnNum++;
            }

            rowLine++;
        }
        wb.write(fos);
        fos.flush();
        fos.close();
    }

    public static Map readCountry(String file, String line) throws IOException {
        Map<String, List<String>> countryMap = Maps.newLinkedHashMap();

        FileReader fr = new FileReader(file);
        BufferedReader br = new BufferedReader(fr);
        String s = br.readLine();
        List<String> list;
        while (s != null) {
            list = Lists.newArrayList();
            String[] fields = s.split("\t", -1);
            for (String field : fields) {
                //                if (field.contains("(")) {
                //                    int six = Integer.parseInt(field.split("\\(",-1)[0]);
                //                    String l = field.split("\\(")[1].split("\\)")[0];
                //                    Double l1 = Double.parseDouble(l);
                //                    BigDecimal bg = new BigDecimal(l1).setScale(4, RoundingMode.UP);
                //                    if (bg.toString().length() > 7) {
                //
                //                    }
                //                    list.add(six+"("+bg.doubleValue()*100+"%)");
                //                } else {
                list.add(field);
                //                }
            }
            countryMap.put(line + ":" + fields[0], list);
            s = br.readLine();//再读下一行
        }
        return countryMap;
    }
}
