package mobvista.dmp.datasource.postback_3s

import java.text.SimpleDateFormat

import mobvista.dmp.datasource.newtag.{Constant, MatchInterestTagDaily}
import org.apache.spark.sql.{DataFrame, SparkSession}


class PostBackTagDaily extends MatchInterestTagDaily with Serializable {
  val sdf1 = new SimpleDateFormat("yyyy-MM-dd")
  val sdf2 = new SimpleDateFormat("yyyyMMdd")

  override def processDailyData(date: String, spark: SparkSession): DataFrame = {
    val sql = Constant.postback_sql.replace("@dt", date)

    spark.sql(sql)
  }
}

object PostBackTagDaily {
  def main(args: Array[String]): Unit = {
    new PostBackTagDaily().run(args)
  }
}