package mobvista.dmp.datasource.toutiao

import mobvista.dmp.common.CommonSparkJob
import org.apache.commons.cli.Options
import org.apache.spark.sql.SparkSession

class DmToutiaoDeviceTag extends CommonSparkJob with Serializable {
  override protected def run(args: Array[String]): Int = {
    val commandLine = commParser.parse(options, args)
    if (!checkMustOption(commandLine)) {
      printUsage(options)
      return 1
    } else {
      printOptions(commandLine)
    }

    val date = commandLine.getOptionValue("date")
    val output = commandLine.getOptionValue("output")

    val tagType = "experience"
    val emptyStr = ""

    val spark = SparkSession.builder()
      .appName("dmp_DmToutiaoTotal_fengliang")
      .config("spark.rdd.compress", "true")
      .config("spark.sql.warehouse.dir", "s3://mob-emr-test/spark-warehouse")
      .config("spark.serializer", "org.apache.spark.serializer.KryoSerializer")
      .enableHiveSupport()
      .getOrCreate()
    import spark.implicits._

    try {
      var sql =
        s"""
          |select t.device_id,
          |       case when lower(t.platform)='ios' then 'idfa'
          |            when lower(t.platform)='android' then 'gaid'
          |       end as device_type,
          |       t.platform,
          |       '' as package_name,
          |       'experience' as tag_type,
          |       t.tag,
          |       '' as second_tag,
          |       t.update_date
          |from (
          |  select /*+ MAPJOIN(a) */ b.device_id,
          |    a.platform,
          |    a.tag,
          |    b.update_date,
          |    row_number() over(partition by b.device_id, a.platform, a.tag order by b.update_date desc) as rk
          |  from dwh.dim_campaign_tags a
          |  join (
          |    select *
          |    from dwh.dm_toutiao_launch_total t
          |    where t.dt='${date}'
          |  ) b on a.campaign_id = b.campaign_id
          |) t
          |where t.rk='1'
        """.stripMargin
      spark.sql(sql)
        .write
        .option("orc.compress", "zlib")
        .orc(output)
    } finally {
      if (spark != null) {
        spark.stop()
      }
    }

    0
  }

  override protected def buildOptions(): Options = {
    val options = new Options
    options.addOption("date", true, "[must] today")
    options.addOption("output", true, "[must] output path")
    options
  }
}

object DmToutiaoDeviceTag {
  def main(args: Array[String]): Unit = {
    new DmToutiaoDeviceTag().run(args)
  }
}

case class DmDeviceTagVO(device_id: String, device_type: String, platform: String, package_name: String, tag_type: String,
                         first_tag: String, second_tag: String, update_date: String)