package mobvista.dmp.datasource.tracking_3s

import mobvista.dmp.common.CommonInstallList
import mobvista.dmp.datasource.mpsdk.InstallInfo
import mobvista.dmp.util.MRUtils

import scala.collection.mutable.ArrayBuffer

/**
  * 将 3s 天数据合并到安装列表全量数据中
  */
class TrackingInstallList extends CommonInstallList {

  /**
    * 解析天处理结果数据
    *
    * @param array
    * @param date
    * @return
    */

  def processDailyData(array: Array[String], date: String): Array[(String, InstallInfo)] = {
    val device_id = array(0)
    val device_type = array(1)
    val platform = array(2)
    val package_name = array(3)
    val date = array(4)
    val installInfo = new InstallInfo(package_name, date)
    val buffer = new ArrayBuffer[(String, InstallInfo)]()
    buffer += Tuple2(MRUtils.JOINER.join(device_id, device_type, platform), installInfo)
    buffer.toArray
  }

  /**
    * 解析天处理结果数据
    *
    * @param array
    * @param date
    * @return
    */
  /*
  override def processDailyData(array: Array[String], date: String): (String, JsonArray) = {
    val device_id = array(0)
    val device_type = array(1)
    val platform = array(2)
    val package_name = array(3)
    val date = array(4)
    val jsonArray = new JsonArray
    val json = new JsonObject
    json.addProperty("package_name", package_name)
    json.addProperty("date", date)
    jsonArray.add(json)
    (MRUtils.JOINER.join(device_id, device_type, platform), jsonArray)
  }
  */
}


object TrackingInstallList {
  def main(args: Array[String]): Unit = {
    new TrackingInstallList().run(args)
  }
}