package mobvista.dmp.function

import java.util

import com.google.gson.JsonObject
import com.googlecode.aviator.runtime.`type`.{AviatorJavaType, AviatorObject}
import com.googlecode.aviator.runtime.function.FunctionUtils
import mobvista.dmp.datasource.address.AddressVO
import mobvista.dmp.datasource.device.OdsDmpUserInfoVO
import mobvista.prd.datasource.util.GsonUtil
import org.apache.commons.lang.StringUtils

class BuildAddressVO extends CommonFunction {
  override def getName: String = "build_addressvo"

  val countryMapping = new util.HashMap[String, String]()
  initCountyMapping()

  override def call(env: util.Map[String, AnyRef], arg1: AviatorObject, arg2: AviatorObject) = {
    val line = FunctionUtils.getStringValue(arg1, env)
    val indices = FunctionUtils.getStringValue(arg2, env)

    val splits = splitFun(line)
    val idxSplits = splitFun(indices, ",")
    val deviceId = splits(idxSplits(0).toInt);
    val platform = splits(idxSplits(1).toInt);
    val req_time = splits(idxSplits(2).toInt).replace("-", "");
    val ip = splits(idxSplits(3).toInt);
    val geo = splits(idxSplits(4).toInt);
    val longitude = splits(idxSplits(5).toInt)
    val latitude = splits(idxSplits(6).toInt)

    val vo = new AddressVO(deviceId, platform, req_time, ip, longitude, latitude)
    if (StringUtils.isNotEmpty(geo)) {
      val json = GsonUtil.String2JsonObject(geo)
      vo.country = countryMapping.get(getJsonProperty(json, "country"))
      vo.province = getJsonProperty(json, "region")
      vo.city = getJsonProperty(json, "city")
    }

    env.put("vo", vo)
    new AviatorJavaType("vo")
  }

  def getJsonProperty(obj: JsonObject, property: String): String = {
    val tmp = obj.get(property)
    if (tmp != null && !tmp.isJsonNull) {
      tmp.getAsString
    } else {
      ""
    }
  }

  def initCountyMapping (): Unit = {
    countryMapping.put("AFG", "AF")
    countryMapping.put("ALB", "AL")
    countryMapping.put("DZA", "DZ")
    countryMapping.put("AND", "AD")
    countryMapping.put("AGO", "AO")
    countryMapping.put("ARG", "AR")
    countryMapping.put("ARM", "AM")
    countryMapping.put("AUS", "AU")
    countryMapping.put("AUT", "AT")
    countryMapping.put("AZE", "AZ")
    countryMapping.put("BHR", "BS")
    countryMapping.put("BHR", "BH")
    countryMapping.put("BGD", "BD")
    countryMapping.put("BLR", "BY")
    countryMapping.put("BEL", "BE")
    countryMapping.put("BEN", "BJ")
    countryMapping.put("BTN", "BT")
    countryMapping.put("BOL", "BO")
    countryMapping.put("BIH", "BA")
    countryMapping.put("BWA", "BW")
    countryMapping.put("BRA", "BR")
    countryMapping.put("BRN", "BN")
    countryMapping.put("BGR", "BG")
    countryMapping.put("BDI", "BI")
    countryMapping.put("KHM", "KH")
    countryMapping.put("CMR", "CM")
    countryMapping.put("CAN", "CA")
    countryMapping.put("CAF", "CF")
    countryMapping.put("TCD", "TD")
    countryMapping.put("CHL", "CL")
    countryMapping.put("CHN", "CN")
    countryMapping.put("HKG", "HK")
    countryMapping.put("MAC", "MO")
    countryMapping.put("TWN", "TW")
    countryMapping.put("COL", "CO")
    countryMapping.put("COM", "KM")
    countryMapping.put("COG", "CG")
    countryMapping.put("COD", "CD")
    countryMapping.put("CRI", "CR")
    countryMapping.put("CIV", "CI")
    countryMapping.put("HRV", "HR")
    countryMapping.put("CUB", "CU")
    countryMapping.put("CYP", "CY")
    countryMapping.put("CZE", "CZ")
    countryMapping.put("DNK", "DK")
    countryMapping.put("DJI", "DJ")
    countryMapping.put("DMA", "DM")
    countryMapping.put("DOM", "DO")
    countryMapping.put("TMP", "TP")
    countryMapping.put("ECU", "EC")
    countryMapping.put("EGY", "EG")
    countryMapping.put("SLV", "SV")
    countryMapping.put("GNQ", "GQ")
    countryMapping.put("ERI", "ER")
    countryMapping.put("EST", "EE")
    countryMapping.put("ETH", "ET")
    countryMapping.put("FJI", "FJ")
    countryMapping.put("FIN", "FI")
    countryMapping.put("FRA", "FR")
    countryMapping.put("GAB", "GA")
    countryMapping.put("GMB", "GM")
    countryMapping.put("GEO", "GE")
    countryMapping.put("DEU", "DE")
    countryMapping.put("GHA", "GH")
    countryMapping.put("GRC", "GR")
    countryMapping.put("GRL", "GL")
    countryMapping.put("GUM", "GU")
    countryMapping.put("GTM", "GT")
    countryMapping.put("GIN", "GN")
    countryMapping.put("GNB", "GW")
    countryMapping.put("GUY", "GY")
    countryMapping.put("HTI", "HT")
    countryMapping.put("HND", "HN")
    countryMapping.put("HUN", "HU")
    countryMapping.put("ISL", "IS")
    countryMapping.put("IND", "IN")
    countryMapping.put("IDN", "ID")
    countryMapping.put("IRN", "IR")
    countryMapping.put("IRQ", "IQ")
    countryMapping.put("IRI", "IE")
    countryMapping.put("ISR", "IL")
    countryMapping.put("ITA", "IT")
    countryMapping.put("JAM", "JM")
    countryMapping.put("JPN", "JP")
    countryMapping.put("JOR", "JO")
    countryMapping.put("KAZ", "KZ")
    countryMapping.put("KEN", "KE")
    countryMapping.put("PRK", "KP")
    countryMapping.put("KOR", "KR")
    countryMapping.put("KWT", "KW")
    countryMapping.put("KGZ", "KG")
    countryMapping.put("LAO", "LA")
    countryMapping.put("LVA", "LV")
    countryMapping.put("LBN", "LB")
    countryMapping.put("LSO", "LS")
    countryMapping.put("LBR", "LR")
    countryMapping.put("LBY", "LY")
    countryMapping.put("LIE", "LI")
    countryMapping.put("LTU", "LT")
    countryMapping.put("LUX", "LU")
    countryMapping.put("MDG", "MG")
    countryMapping.put("MWI", "MW")
    countryMapping.put("MYS", "MY")
    countryMapping.put("MDV", "MV")
    countryMapping.put("MLA", "ML")
    countryMapping.put("MLT", "MT")
    countryMapping.put("MRT", "MR")
    countryMapping.put("MUS", "MU")
    countryMapping.put("MEX", "MX")
    countryMapping.put("MDA", "MD")
    countryMapping.put("MCO", "MC")
    countryMapping.put("MNG", "MN")
    countryMapping.put("MAR", "MA")
    countryMapping.put("MOZ", "MZ")
    countryMapping.put("MMR", "MM")
    countryMapping.put("NAM", "NA")
    countryMapping.put("NRU", "NR")
    countryMapping.put("NPL", "NP")
    countryMapping.put("NLD", "NL")
    countryMapping.put("NZL", "NZ")
    countryMapping.put("NIC", "NI")
    countryMapping.put("NER", "NE")
    countryMapping.put("NGA", "NG")
    countryMapping.put("NOR", "NO")
    countryMapping.put("OMN", "OM")
    countryMapping.put("PAK", "PK")
    countryMapping.put("PSE", "PS")
    countryMapping.put("PAN", "PA")
    countryMapping.put("PNG", "PG")
    countryMapping.put("PRY", "PY")
    countryMapping.put("PER", "PE")
    countryMapping.put("PHL", "PH")
    countryMapping.put("POL", "PL")
    countryMapping.put("PRT", "PT")
    countryMapping.put("PRI", "PR")
    countryMapping.put("QAT", "QA")
    countryMapping.put("ROM", "RO")
    countryMapping.put("RUS", "RU")
    countryMapping.put("RWA", "RW")
    countryMapping.put("SMR", "SM")
    countryMapping.put("SAU", "SA")
    countryMapping.put("SEN", "SN")
    countryMapping.put("SYC", "SC")
    countryMapping.put("SLE", "SL")
    countryMapping.put("SGP", "SG")
    countryMapping.put("SVK", "SK")
    countryMapping.put("SVN", "SI")
    countryMapping.put("SOM", "SO")
    countryMapping.put("ZAF", "ZA")
    countryMapping.put("ESP", "ES")
    countryMapping.put("LKA", "LK")
    countryMapping.put("SDN", "SD")
    countryMapping.put("SWZ", "SZ")
    countryMapping.put("SWE", "SE")
    countryMapping.put("CHE", "CH")
    countryMapping.put("SYR", "SY")
    countryMapping.put("TJK", "TJ")
    countryMapping.put("TZA", "TZ")
    countryMapping.put("THA", "TH")
    countryMapping.put("TGO", "TG")
    countryMapping.put("TON", "TO")
    countryMapping.put("TTO", "TT")
    countryMapping.put("TUN", "TN")
    countryMapping.put("TUR", "TR")
    countryMapping.put("TKM", "TM")
    countryMapping.put("UGA", "UG")
    countryMapping.put("UKR", "UA")
    countryMapping.put("ARE", "AE")
    countryMapping.put("GBR", "GB")
    countryMapping.put("USA", "US")
    countryMapping.put("URY", "UY")
    countryMapping.put("UZB", "UZ")
    countryMapping.put("VAT", "VA")
    countryMapping.put("VEN", "VE")
    countryMapping.put("VNM", "VN")
    countryMapping.put("VGB", "VG")
    countryMapping.put("VIR", "VI")
    countryMapping.put("YEM", "YE")
    countryMapping.put("YUG", "YU")
    countryMapping.put("ZMB", "ZM")
    countryMapping.put("ZWE", "ZW")
  }
}
